/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.erd.router.ortho;

import com.dbeaver.ee.erd.router.ortho.OrthoPathUtils;
import com.dbeaver.ee.erd.router.ortho.RouteLine;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Geometry;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class OrthogonalConnection
extends PolylineConnection {
    private static final int ROUNDED_RADIUS = 7;
    private static final int TOLERANCE = 2;
    private static final boolean IS_DEBUG_MODE = false;
    private boolean isLineSelected = false;
    private List<RouteLine> overlappingLinesByX = new ArrayList<RouteLine>();
    private List<RouteLine> overlappingLinesByY = new ArrayList<RouteLine>();
    private PointList crossRouters = new PointList();

    protected void outlineShape(Graphics g) {
        g.setAntialias(1);
        PointList points = this.getOrthoPoints();
        if (this.isLineSelected) {
            g.setLineWidth(4);
        }
        this.drawRoute(g, points);
        this.drawBridges(g);
    }

    private void drawRoute(Graphics g, PointList points) {
        g.drawPolyline(points);
    }

    private void drawBridges(Graphics g) {
        int i = 0;
        while (i < this.crossRouters.size()) {
            Point p = this.crossRouters.getPoint(i);
            g.fillArc(p.x - 5, p.y - 5, 10, 12, 0, 180);
            g.drawArc(p.x - 5, p.y - 5, 10, 10, 0, 180);
            ++i;
        }
    }

    private PointList transformToBeizer(PointList points, Graphics g) {
        PointList beizerPointList = new PointList();
        int i = 1;
        while (i < points.size()) {
            Point p0 = points.getPoint(i - 1);
            Point cornerPoint = points.getPoint(i);
            if (i + 1 < points.size()) {
                Point p2 = points.getPoint(i + 1);
                RouteLine line1 = new RouteLine(p0, cornerPoint);
                RouteLine line2 = new RouteLine(cornerPoint, p2);
                if (cornerPoint.x == p0.x && cornerPoint.x == p2.x) {
                    if (i == 1) {
                        beizerPointList.addPoint(p0);
                    }
                    beizerPointList.addPoint(cornerPoint);
                } else if (cornerPoint.y == p0.y && cornerPoint.y == p2.y) {
                    if (i == 1) {
                        beizerPointList.addPoint(p0);
                    }
                    beizerPointList.addPoint(cornerPoint);
                } else if (cornerPoint.x == p0.x && cornerPoint.y == p2.y || cornerPoint.y == p0.y && cornerPoint.x == p2.x) {
                    if (i == 1) {
                        beizerPointList.addPoint(p0);
                    }
                    boolean isIntersects = false;
                    for (RouteLine line : this.overlappingLinesByY) {
                        if (!OrthoPathUtils.polylineContainsPoint(line, cornerPoint)) continue;
                        isIntersects = true;
                        break;
                    }
                    if (line1.getLength() < 20.0 || line2.getLength() < 20.0) {
                        beizerPointList.addPoint(cornerPoint);
                    } else if (isIntersects || i == points.size() - 2) {
                        int dx1 = (int)(Math.cos(line1.getAngel()) * 7.0);
                        int dy1 = (int)(Math.sin(line1.getAngel()) * 7.0);
                        int dx2 = (int)(Math.cos(line2.getAngel()) * 7.0);
                        int dy2 = (int)(Math.sin(line2.getAngel()) * 7.0);
                        Point p01 = new Point(cornerPoint.x - dx1, cornerPoint.y - dy1);
                        Point p02 = new Point(cornerPoint.x + dx2, cornerPoint.y + dy2);
                        PointList corner = new PointList();
                        corner.addPoint(p01);
                        corner.addPoint(cornerPoint);
                        corner.addPoint(p02);
                        beizerPointList.addPoint(p01);
                        beizerPointList.addPoint(p02);
                    } else {
                        beizerPointList.addPoint(cornerPoint);
                    }
                }
            } else {
                beizerPointList.addPoint(cornerPoint);
            }
            ++i;
        }
        return beizerPointList;
    }

    private void drawOverlappingLinesByX(Graphics g) {
        g.setLineWidth(2);
        for (RouteLine routeLine : this.overlappingLinesByX) {
            g.drawLine(routeLine.getFirst(), routeLine.getLast());
            g.fillOval(routeLine.getLast().x - 2, routeLine.getLast().y - 2, 4, 4);
            g.fillOval(routeLine.getFirst().x - 2, routeLine.getFirst().y - 2, 4, 4);
        }
    }

    private void drawOverlappingLinesByY(Graphics g) {
        g.setLineWidth(2);
        for (RouteLine routeLine : this.overlappingLinesByY) {
            g.drawLine(routeLine.getFirst(), routeLine.getLast());
            g.fillOval(routeLine.getLast().x - 2, routeLine.getLast().y - 2, 4, 4);
            g.fillOval(routeLine.getFirst().x - 2, routeLine.getFirst().y - 2, 4, 4);
        }
    }

    private PointList getOrthoPoints() {
        return this.getPoints();
    }

    public PointList getBezierPoints(PointList controlPoints) {
        if (controlPoints.size() >= 3) {
            int index = 0;
            PointList pointList = new PointList();
            Point p0 = controlPoints.getPoint(index++);
            Point p1 = controlPoints.getPoint(index++);
            Point p2 = null;
            Point nextPoint = controlPoints.getPoint(index++);
            while (true) {
                p2 = nextPoint;
                double t = 0.0;
                while (t <= 1.0) {
                    Point point = new Point();
                    point.x = (int)((double)p0.x * (1.0 - t) * (1.0 - t) + (double)(2 * p1.x) * t * (1.0 - t) + (double)p2.x * t * t);
                    point.y = (int)((double)p0.y * (1.0 - t) * (1.0 - t) + (double)(2 * p1.y) * t * (1.0 - t) + (double)p2.y * t * t);
                    pointList.addPoint(point);
                    t += 0.01;
                }
                pointList.addPoint(p2);
                if (index == controlPoints.size()) break;
                p0 = p2;
                p1 = nextPoint;
                nextPoint = controlPoints.getPoint(index++);
            }
            return pointList;
        }
        return controlPoints;
    }

    protected boolean shapeContainsPoint(int x, int y) {
        return Geometry.polylineContainsPoint((PointList)this.getBezierPoints(this.getPoints()), (int)x, (int)y, (int)2);
    }

    public void cleanupOverlappedPoints() {
        this.overlappingLinesByY.clear();
        this.overlappingLinesByX.clear();
        this.crossRouters.removeAllPoints();
    }

    public void revalidate() {
        super.revalidate();
        if (this.overlappingLinesByY != null) {
            this.overlappingLinesByY.clear();
        }
        if (this.overlappingLinesByX != null) {
            this.overlappingLinesByX.clear();
        }
        if (this.crossRouters != null) {
            this.crossRouters.removeAllPoints();
        }
    }

    public void cleanupCrossRouters() {
        this.crossRouters.removeAllPoints();
    }

    public void setCrossRouters(PointList crossRouters) {
        this.crossRouters.removeAllPoints();
        this.crossRouters.addAll(crossRouters);
    }

    public List<RouteLine> getOverlappingLinesByY() {
        return this.overlappingLinesByY;
    }

    public void setOverlappingLinesByY(List<RouteLine> overlappingLinesByY) {
        this.overlappingLinesByY = overlappingLinesByY;
    }

    public List<RouteLine> getOverlappingLinesByX() {
        return this.overlappingLinesByX;
    }

    public void setOverlappingLinesByX(List<RouteLine> overlappingLinesByX) {
        this.overlappingLinesByX = overlappingLinesByX;
    }
}

