/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.models.InfrastructureEncryption;
import com.azure.resourcemanager.mysql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.mysql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.mysql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.mysql.models.ServerVersion;
import com.azure.resourcemanager.mysql.models.SslEnforcementEnum;
import com.azure.resourcemanager.mysql.models.StorageProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="createMode")
@JsonTypeName(value="Replica")
public final class ServerPropertiesForReplica
extends ServerPropertiesForCreate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerPropertiesForReplica.class);
    @JsonProperty(value="sourceServerId", required=true)
    private String sourceServerId;

    public String sourceServerId() {
        return this.sourceServerId;
    }

    public ServerPropertiesForReplica withSourceServerId(String sourceServerId) {
        this.sourceServerId = sourceServerId;
        return this;
    }

    @Override
    public ServerPropertiesForReplica withVersion(ServerVersion version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public ServerPropertiesForReplica withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        super.withSslEnforcement(sslEnforcement);
        return this;
    }

    @Override
    public ServerPropertiesForReplica withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        super.withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    @Override
    public ServerPropertiesForReplica withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        super.withInfrastructureEncryption(infrastructureEncryption);
        return this;
    }

    @Override
    public ServerPropertiesForReplica withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ServerPropertiesForReplica withStorageProfile(StorageProfile storageProfile) {
        super.withStorageProfile(storageProfile);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.sourceServerId() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceServerId in model ServerPropertiesForReplica"));
        }
    }
}

