/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.ServerSecurityAlertPoliciesClient;
import com.azure.resourcemanager.mysql.fluent.models.ServerSecurityAlertPolicyInner;
import com.azure.resourcemanager.mysql.implementation.ServerSecurityAlertPolicyImpl;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.SecurityAlertPolicyName;
import com.azure.resourcemanager.mysql.models.ServerSecurityAlertPolicies;
import com.azure.resourcemanager.mysql.models.ServerSecurityAlertPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ServerSecurityAlertPoliciesImpl
implements ServerSecurityAlertPolicies {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerSecurityAlertPoliciesImpl.class);
    private final ServerSecurityAlertPoliciesClient innerClient;
    private final MySqlManager serviceManager;

    public ServerSecurityAlertPoliciesImpl(ServerSecurityAlertPoliciesClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public ServerSecurityAlertPolicy get(String resourceGroupName, String serverName, SecurityAlertPolicyName securityAlertPolicyName) {
        ServerSecurityAlertPolicyInner inner = this.serviceClient().get(resourceGroupName, serverName, securityAlertPolicyName);
        if (inner != null) {
            return new ServerSecurityAlertPolicyImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<ServerSecurityAlertPolicy> getWithResponse(String resourceGroupName, String serverName, SecurityAlertPolicyName securityAlertPolicyName, Context context) {
        Response<ServerSecurityAlertPolicyInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, securityAlertPolicyName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServerSecurityAlertPolicyImpl((ServerSecurityAlertPolicyInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<ServerSecurityAlertPolicy> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ServerSecurityAlertPolicyInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new ServerSecurityAlertPolicyImpl((ServerSecurityAlertPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ServerSecurityAlertPolicy> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerSecurityAlertPolicyInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new ServerSecurityAlertPolicyImpl((ServerSecurityAlertPolicyInner)((Object)inner1), this.manager()));
    }

    @Override
    public ServerSecurityAlertPolicy getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        SecurityAlertPolicyName securityAlertPolicyName = SecurityAlertPolicyName.fromString(Utils.getValueFromIdByName(id, "securityAlertPolicies"));
        if (securityAlertPolicyName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityAlertPolicies'.", id)));
        }
        return (ServerSecurityAlertPolicy)this.getWithResponse(resourceGroupName, serverName, securityAlertPolicyName, Context.NONE).getValue();
    }

    @Override
    public Response<ServerSecurityAlertPolicy> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "servers");
        if (serverName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'servers'.", id)));
        }
        SecurityAlertPolicyName securityAlertPolicyName = SecurityAlertPolicyName.fromString(Utils.getValueFromIdByName(id, "securityAlertPolicies"));
        if (securityAlertPolicyName == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'securityAlertPolicies'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, securityAlertPolicyName, context);
    }

    private ServerSecurityAlertPoliciesClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerSecurityAlertPolicyImpl define(SecurityAlertPolicyName name) {
        return new ServerSecurityAlertPolicyImpl(name, this.manager());
    }
}

