/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.models.ServerInner;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.InfrastructureEncryption;
import com.azure.resourcemanager.mysql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.mysql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.mysql.models.ResourceIdentity;
import com.azure.resourcemanager.mysql.models.Server;
import com.azure.resourcemanager.mysql.models.ServerForCreate;
import com.azure.resourcemanager.mysql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.mysql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.mysql.models.ServerState;
import com.azure.resourcemanager.mysql.models.ServerUpdateParameters;
import com.azure.resourcemanager.mysql.models.ServerUpgradeParameters;
import com.azure.resourcemanager.mysql.models.ServerVersion;
import com.azure.resourcemanager.mysql.models.Sku;
import com.azure.resourcemanager.mysql.models.SslEnforcementEnum;
import com.azure.resourcemanager.mysql.models.StorageProfile;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ServerImpl
implements Server,
Server.Definition,
Server.Update {
    private ServerInner innerObject;
    private final MySqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private ServerForCreate createParameters;
    private ServerUpdateParameters updateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public ResourceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public Sku sku() {
        return this.innerModel().sku();
    }

    @Override
    public String administratorLogin() {
        return this.innerModel().administratorLogin();
    }

    @Override
    public ServerVersion version() {
        return this.innerModel().version();
    }

    @Override
    public SslEnforcementEnum sslEnforcement() {
        return this.innerModel().sslEnforcement();
    }

    @Override
    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.innerModel().minimalTlsVersion();
    }

    @Override
    public String byokEnforcement() {
        return this.innerModel().byokEnforcement();
    }

    @Override
    public InfrastructureEncryption infrastructureEncryption() {
        return this.innerModel().infrastructureEncryption();
    }

    @Override
    public ServerState userVisibleState() {
        return this.innerModel().userVisibleState();
    }

    @Override
    public String fullyQualifiedDomainName() {
        return this.innerModel().fullyQualifiedDomainName();
    }

    @Override
    public OffsetDateTime earliestRestoreDate() {
        return this.innerModel().earliestRestoreDate();
    }

    @Override
    public StorageProfile storageProfile() {
        return this.innerModel().storageProfile();
    }

    @Override
    public String replicationRole() {
        return this.innerModel().replicationRole();
    }

    @Override
    public String masterServerId() {
        return this.innerModel().masterServerId();
    }

    @Override
    public Integer replicaCapacity() {
        return this.innerModel().replicaCapacity();
    }

    @Override
    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.innerModel().publicNetworkAccess();
    }

    @Override
    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        List<ServerPrivateEndpointConnection> inner = this.innerModel().privateEndpointConnections();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public ServerInner innerModel() {
        return this.innerObject;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ServerImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public Server create() {
        this.innerObject = this.serviceManager.serviceClient().getServers().create(this.resourceGroupName, this.serverName, this.createParameters, Context.NONE);
        return this;
    }

    @Override
    public Server create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServers().create(this.resourceGroupName, this.serverName, this.createParameters, context);
        return this;
    }

    ServerImpl(String name, MySqlManager serviceManager) {
        this.innerObject = new ServerInner();
        this.serviceManager = serviceManager;
        this.serverName = name;
        this.createParameters = new ServerForCreate();
    }

    @Override
    public ServerImpl update() {
        this.updateParameters = new ServerUpdateParameters();
        return this;
    }

    @Override
    public Server apply() {
        this.innerObject = this.serviceManager.serviceClient().getServers().update(this.resourceGroupName, this.serverName, this.updateParameters, Context.NONE);
        return this;
    }

    @Override
    public Server apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getServers().update(this.resourceGroupName, this.serverName, this.updateParameters, context);
        return this;
    }

    ServerImpl(ServerInner innerObject, MySqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = Utils.getValueFromIdByName(innerObject.id(), "servers");
    }

    @Override
    public Server refresh() {
        this.innerObject = (ServerInner)((Object)this.serviceManager.serviceClient().getServers().getByResourceGroupWithResponse(this.resourceGroupName, this.serverName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Server refresh(Context context) {
        this.innerObject = (ServerInner)((Object)this.serviceManager.serviceClient().getServers().getByResourceGroupWithResponse(this.resourceGroupName, this.serverName, context).getValue());
        return this;
    }

    @Override
    public void restart() {
        this.serviceManager.servers().restart(this.resourceGroupName, this.serverName);
    }

    @Override
    public void restart(Context context) {
        this.serviceManager.servers().restart(this.resourceGroupName, this.serverName, context);
    }

    @Override
    public void start() {
        this.serviceManager.servers().start(this.resourceGroupName, this.serverName);
    }

    @Override
    public void start(Context context) {
        this.serviceManager.servers().start(this.resourceGroupName, this.serverName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.servers().stop(this.resourceGroupName, this.serverName);
    }

    @Override
    public void stop(Context context) {
        this.serviceManager.servers().stop(this.resourceGroupName, this.serverName, context);
    }

    @Override
    public void upgrade(ServerUpgradeParameters parameters) {
        this.serviceManager.servers().upgrade(this.resourceGroupName, this.serverName, parameters);
    }

    @Override
    public void upgrade(ServerUpgradeParameters parameters, Context context) {
        this.serviceManager.servers().upgrade(this.resourceGroupName, this.serverName, parameters, context);
    }

    @Override
    public ServerImpl withRegion(Region location) {
        this.createParameters.withLocation(location.toString());
        return this;
    }

    @Override
    public ServerImpl withRegion(String location) {
        this.createParameters.withLocation(location);
        return this;
    }

    @Override
    public ServerImpl withProperties(ServerPropertiesForCreate properties) {
        this.createParameters.withProperties(properties);
        return this;
    }

    @Override
    public ServerImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.createParameters.withTags(tags);
            return this;
        }
        this.updateParameters.withTags(tags);
        return this;
    }

    @Override
    public ServerImpl withIdentity(ResourceIdentity identity) {
        if (this.isInCreateMode()) {
            this.createParameters.withIdentity(identity);
            return this;
        }
        this.updateParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ServerImpl withSku(Sku sku) {
        if (this.isInCreateMode()) {
            this.createParameters.withSku(sku);
            return this;
        }
        this.updateParameters.withSku(sku);
        return this;
    }

    @Override
    public ServerImpl withStorageProfile(StorageProfile storageProfile) {
        this.updateParameters.withStorageProfile(storageProfile);
        return this;
    }

    @Override
    public ServerImpl withAdministratorLoginPassword(String administratorLoginPassword) {
        this.updateParameters.withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public ServerImpl withVersion(ServerVersion version) {
        this.updateParameters.withVersion(version);
        return this;
    }

    @Override
    public ServerImpl withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        this.updateParameters.withSslEnforcement(sslEnforcement);
        return this;
    }

    @Override
    public ServerImpl withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        this.updateParameters.withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    @Override
    public ServerImpl withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        this.updateParameters.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ServerImpl withReplicationRole(String replicationRole) {
        this.updateParameters.withReplicationRole(replicationRole);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel().id() == null;
    }
}

