/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.ResourceProvidersClient;
import com.azure.resourcemanager.mysql.fluent.models.QueryPerformanceInsightResetDataResultInner;
import com.azure.resourcemanager.mysql.implementation.QueryPerformanceInsightResetDataResultImpl;
import com.azure.resourcemanager.mysql.models.QueryPerformanceInsightResetDataResult;
import com.azure.resourcemanager.mysql.models.ResourceProviders;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ResourceProvidersImpl
implements ResourceProviders {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ResourceProvidersImpl.class);
    private final ResourceProvidersClient innerClient;
    private final MySqlManager serviceManager;

    public ResourceProvidersImpl(ResourceProvidersClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public QueryPerformanceInsightResetDataResult resetQueryPerformanceInsightData(String resourceGroupName, String serverName) {
        QueryPerformanceInsightResetDataResultInner inner = this.serviceClient().resetQueryPerformanceInsightData(resourceGroupName, serverName);
        if (inner != null) {
            return new QueryPerformanceInsightResetDataResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<QueryPerformanceInsightResetDataResult> resetQueryPerformanceInsightDataWithResponse(String resourceGroupName, String serverName, Context context) {
        Response<QueryPerformanceInsightResetDataResultInner> inner = this.serviceClient().resetQueryPerformanceInsightDataWithResponse(resourceGroupName, serverName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new QueryPerformanceInsightResetDataResultImpl((QueryPerformanceInsightResetDataResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    @Override
    public void createRecommendedActionSession(String resourceGroupName, String serverName, String advisorName, String databaseName) {
        this.serviceClient().createRecommendedActionSession(resourceGroupName, serverName, advisorName, databaseName);
    }

    @Override
    public void createRecommendedActionSession(String resourceGroupName, String serverName, String advisorName, String databaseName, Context context) {
        this.serviceClient().createRecommendedActionSession(resourceGroupName, serverName, advisorName, databaseName, context);
    }

    private ResourceProvidersClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

