/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.RecoverableServersClient;
import com.azure.resourcemanager.mysql.fluent.models.RecoverableServerResourceInner;
import com.azure.resourcemanager.mysql.implementation.RecoverableServerResourceImpl;
import com.azure.resourcemanager.mysql.models.RecoverableServerResource;
import com.azure.resourcemanager.mysql.models.RecoverableServers;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class RecoverableServersImpl
implements RecoverableServers {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RecoverableServersImpl.class);
    private final RecoverableServersClient innerClient;
    private final MySqlManager serviceManager;

    public RecoverableServersImpl(RecoverableServersClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public RecoverableServerResource get(String resourceGroupName, String serverName) {
        RecoverableServerResourceInner inner = this.serviceClient().get(resourceGroupName, serverName);
        if (inner != null) {
            return new RecoverableServerResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<RecoverableServerResource> getWithResponse(String resourceGroupName, String serverName, Context context) {
        Response<RecoverableServerResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new RecoverableServerResourceImpl((RecoverableServerResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    private RecoverableServersClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

