/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.QueryTextsClient;
import com.azure.resourcemanager.mysql.fluent.models.QueryTextInner;
import com.azure.resourcemanager.mysql.implementation.QueryTextImpl;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.QueryText;
import com.azure.resourcemanager.mysql.models.QueryTexts;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;

public final class QueryTextsImpl
implements QueryTexts {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(QueryTextsImpl.class);
    private final QueryTextsClient innerClient;
    private final MySqlManager serviceManager;

    public QueryTextsImpl(QueryTextsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public QueryText get(String resourceGroupName, String serverName, String queryId) {
        QueryTextInner inner = this.serviceClient().get(resourceGroupName, serverName, queryId);
        if (inner != null) {
            return new QueryTextImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<QueryText> getWithResponse(String resourceGroupName, String serverName, String queryId, Context context) {
        Response<QueryTextInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, queryId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new QueryTextImpl((QueryTextInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<QueryText> listByServer(String resourceGroupName, String serverName, List<String> queryIds) {
        PagedIterable<QueryTextInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, queryIds);
        return Utils.mapPage(inner, inner1 -> new QueryTextImpl((QueryTextInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<QueryText> listByServer(String resourceGroupName, String serverName, List<String> queryIds, Context context) {
        PagedIterable<QueryTextInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, queryIds, context);
        return Utils.mapPage(inner, inner1 -> new QueryTextImpl((QueryTextInner)((Object)inner1), this.manager()));
    }

    private QueryTextsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

