/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.fluent.MySqlManagementClient;
import com.azure.resourcemanager.mysql.implementation.AdvisorsImpl;
import com.azure.resourcemanager.mysql.implementation.CheckNameAvailabilitiesImpl;
import com.azure.resourcemanager.mysql.implementation.ConfigurationsImpl;
import com.azure.resourcemanager.mysql.implementation.DatabasesImpl;
import com.azure.resourcemanager.mysql.implementation.FirewallRulesImpl;
import com.azure.resourcemanager.mysql.implementation.LocationBasedPerformanceTiersImpl;
import com.azure.resourcemanager.mysql.implementation.LocationBasedRecommendedActionSessionsOperationStatusImpl;
import com.azure.resourcemanager.mysql.implementation.LocationBasedRecommendedActionSessionsResultsImpl;
import com.azure.resourcemanager.mysql.implementation.LogFilesImpl;
import com.azure.resourcemanager.mysql.implementation.MySqlManagementClientBuilder;
import com.azure.resourcemanager.mysql.implementation.OperationsImpl;
import com.azure.resourcemanager.mysql.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.mysql.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.mysql.implementation.QueryTextsImpl;
import com.azure.resourcemanager.mysql.implementation.RecommendedActionsImpl;
import com.azure.resourcemanager.mysql.implementation.RecoverableServersImpl;
import com.azure.resourcemanager.mysql.implementation.ReplicasImpl;
import com.azure.resourcemanager.mysql.implementation.ResourceProvidersImpl;
import com.azure.resourcemanager.mysql.implementation.ServerAdministratorsImpl;
import com.azure.resourcemanager.mysql.implementation.ServerBasedPerformanceTiersImpl;
import com.azure.resourcemanager.mysql.implementation.ServerKeysImpl;
import com.azure.resourcemanager.mysql.implementation.ServerParametersImpl;
import com.azure.resourcemanager.mysql.implementation.ServerSecurityAlertPoliciesImpl;
import com.azure.resourcemanager.mysql.implementation.ServersImpl;
import com.azure.resourcemanager.mysql.implementation.TopQueryStatisticsImpl;
import com.azure.resourcemanager.mysql.implementation.VirtualNetworkRulesImpl;
import com.azure.resourcemanager.mysql.implementation.WaitStatisticsImpl;
import com.azure.resourcemanager.mysql.models.Advisors;
import com.azure.resourcemanager.mysql.models.CheckNameAvailabilities;
import com.azure.resourcemanager.mysql.models.Configurations;
import com.azure.resourcemanager.mysql.models.Databases;
import com.azure.resourcemanager.mysql.models.FirewallRules;
import com.azure.resourcemanager.mysql.models.LocationBasedPerformanceTiers;
import com.azure.resourcemanager.mysql.models.LocationBasedRecommendedActionSessionsOperationStatus;
import com.azure.resourcemanager.mysql.models.LocationBasedRecommendedActionSessionsResults;
import com.azure.resourcemanager.mysql.models.LogFiles;
import com.azure.resourcemanager.mysql.models.Operations;
import com.azure.resourcemanager.mysql.models.PrivateEndpointConnections;
import com.azure.resourcemanager.mysql.models.PrivateLinkResources;
import com.azure.resourcemanager.mysql.models.QueryTexts;
import com.azure.resourcemanager.mysql.models.RecommendedActions;
import com.azure.resourcemanager.mysql.models.RecoverableServers;
import com.azure.resourcemanager.mysql.models.Replicas;
import com.azure.resourcemanager.mysql.models.ResourceProviders;
import com.azure.resourcemanager.mysql.models.ServerAdministrators;
import com.azure.resourcemanager.mysql.models.ServerBasedPerformanceTiers;
import com.azure.resourcemanager.mysql.models.ServerKeys;
import com.azure.resourcemanager.mysql.models.ServerParameters;
import com.azure.resourcemanager.mysql.models.ServerSecurityAlertPolicies;
import com.azure.resourcemanager.mysql.models.Servers;
import com.azure.resourcemanager.mysql.models.TopQueryStatistics;
import com.azure.resourcemanager.mysql.models.VirtualNetworkRules;
import com.azure.resourcemanager.mysql.models.WaitStatistics;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MySqlManager {
    private Servers servers;
    private Replicas replicas;
    private FirewallRules firewallRules;
    private VirtualNetworkRules virtualNetworkRules;
    private Databases databases;
    private Configurations configurations;
    private ServerParameters serverParameters;
    private LogFiles logFiles;
    private ServerAdministrators serverAdministrators;
    private RecoverableServers recoverableServers;
    private ServerBasedPerformanceTiers serverBasedPerformanceTiers;
    private LocationBasedPerformanceTiers locationBasedPerformanceTiers;
    private CheckNameAvailabilities checkNameAvailabilities;
    private Operations operations;
    private ServerSecurityAlertPolicies serverSecurityAlertPolicies;
    private QueryTexts queryTexts;
    private TopQueryStatistics topQueryStatistics;
    private WaitStatistics waitStatistics;
    private ResourceProviders resourceProviders;
    private Advisors advisors;
    private RecommendedActions recommendedActions;
    private LocationBasedRecommendedActionSessionsOperationStatus locationBasedRecommendedActionSessionsOperationStatus;
    private LocationBasedRecommendedActionSessionsResults locationBasedRecommendedActionSessionsResults;
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private ServerKeys serverKeys;
    private final MySqlManagementClient clientObject;

    private MySqlManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new MySqlManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static MySqlManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return MySqlManager.configure().authenticate(credential, profile);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Servers servers() {
        if (this.servers == null) {
            this.servers = new ServersImpl(this.clientObject.getServers(), this);
        }
        return this.servers;
    }

    public Replicas replicas() {
        if (this.replicas == null) {
            this.replicas = new ReplicasImpl(this.clientObject.getReplicas(), this);
        }
        return this.replicas;
    }

    public FirewallRules firewallRules() {
        if (this.firewallRules == null) {
            this.firewallRules = new FirewallRulesImpl(this.clientObject.getFirewallRules(), this);
        }
        return this.firewallRules;
    }

    public VirtualNetworkRules virtualNetworkRules() {
        if (this.virtualNetworkRules == null) {
            this.virtualNetworkRules = new VirtualNetworkRulesImpl(this.clientObject.getVirtualNetworkRules(), this);
        }
        return this.virtualNetworkRules;
    }

    public Databases databases() {
        if (this.databases == null) {
            this.databases = new DatabasesImpl(this.clientObject.getDatabases(), this);
        }
        return this.databases;
    }

    public Configurations configurations() {
        if (this.configurations == null) {
            this.configurations = new ConfigurationsImpl(this.clientObject.getConfigurations(), this);
        }
        return this.configurations;
    }

    public ServerParameters serverParameters() {
        if (this.serverParameters == null) {
            this.serverParameters = new ServerParametersImpl(this.clientObject.getServerParameters(), this);
        }
        return this.serverParameters;
    }

    public LogFiles logFiles() {
        if (this.logFiles == null) {
            this.logFiles = new LogFilesImpl(this.clientObject.getLogFiles(), this);
        }
        return this.logFiles;
    }

    public ServerAdministrators serverAdministrators() {
        if (this.serverAdministrators == null) {
            this.serverAdministrators = new ServerAdministratorsImpl(this.clientObject.getServerAdministrators(), this);
        }
        return this.serverAdministrators;
    }

    public RecoverableServers recoverableServers() {
        if (this.recoverableServers == null) {
            this.recoverableServers = new RecoverableServersImpl(this.clientObject.getRecoverableServers(), this);
        }
        return this.recoverableServers;
    }

    public ServerBasedPerformanceTiers serverBasedPerformanceTiers() {
        if (this.serverBasedPerformanceTiers == null) {
            this.serverBasedPerformanceTiers = new ServerBasedPerformanceTiersImpl(this.clientObject.getServerBasedPerformanceTiers(), this);
        }
        return this.serverBasedPerformanceTiers;
    }

    public LocationBasedPerformanceTiers locationBasedPerformanceTiers() {
        if (this.locationBasedPerformanceTiers == null) {
            this.locationBasedPerformanceTiers = new LocationBasedPerformanceTiersImpl(this.clientObject.getLocationBasedPerformanceTiers(), this);
        }
        return this.locationBasedPerformanceTiers;
    }

    public CheckNameAvailabilities checkNameAvailabilities() {
        if (this.checkNameAvailabilities == null) {
            this.checkNameAvailabilities = new CheckNameAvailabilitiesImpl(this.clientObject.getCheckNameAvailabilities(), this);
        }
        return this.checkNameAvailabilities;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public ServerSecurityAlertPolicies serverSecurityAlertPolicies() {
        if (this.serverSecurityAlertPolicies == null) {
            this.serverSecurityAlertPolicies = new ServerSecurityAlertPoliciesImpl(this.clientObject.getServerSecurityAlertPolicies(), this);
        }
        return this.serverSecurityAlertPolicies;
    }

    public QueryTexts queryTexts() {
        if (this.queryTexts == null) {
            this.queryTexts = new QueryTextsImpl(this.clientObject.getQueryTexts(), this);
        }
        return this.queryTexts;
    }

    public TopQueryStatistics topQueryStatistics() {
        if (this.topQueryStatistics == null) {
            this.topQueryStatistics = new TopQueryStatisticsImpl(this.clientObject.getTopQueryStatistics(), this);
        }
        return this.topQueryStatistics;
    }

    public WaitStatistics waitStatistics() {
        if (this.waitStatistics == null) {
            this.waitStatistics = new WaitStatisticsImpl(this.clientObject.getWaitStatistics(), this);
        }
        return this.waitStatistics;
    }

    public ResourceProviders resourceProviders() {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ResourceProvidersImpl(this.clientObject.getResourceProviders(), this);
        }
        return this.resourceProviders;
    }

    public Advisors advisors() {
        if (this.advisors == null) {
            this.advisors = new AdvisorsImpl(this.clientObject.getAdvisors(), this);
        }
        return this.advisors;
    }

    public RecommendedActions recommendedActions() {
        if (this.recommendedActions == null) {
            this.recommendedActions = new RecommendedActionsImpl(this.clientObject.getRecommendedActions(), this);
        }
        return this.recommendedActions;
    }

    public LocationBasedRecommendedActionSessionsOperationStatus locationBasedRecommendedActionSessionsOperationStatus() {
        if (this.locationBasedRecommendedActionSessionsOperationStatus == null) {
            this.locationBasedRecommendedActionSessionsOperationStatus = new LocationBasedRecommendedActionSessionsOperationStatusImpl(this.clientObject.getLocationBasedRecommendedActionSessionsOperationStatus(), this);
        }
        return this.locationBasedRecommendedActionSessionsOperationStatus;
    }

    public LocationBasedRecommendedActionSessionsResults locationBasedRecommendedActionSessionsResults() {
        if (this.locationBasedRecommendedActionSessionsResults == null) {
            this.locationBasedRecommendedActionSessionsResults = new LocationBasedRecommendedActionSessionsResultsImpl(this.clientObject.getLocationBasedRecommendedActionSessionsResults(), this);
        }
        return this.locationBasedRecommendedActionSessionsResults;
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public ServerKeys serverKeys() {
        if (this.serverKeys == null) {
            this.serverKeys = new ServerKeysImpl(this.clientObject.getServerKeys(), this);
        }
        return this.serverKeys;
    }

    public MySqlManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private final ClientLogger logger = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'retryPolicy' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'httpPipeline' cannot be negative"));
            }
            return this;
        }

        public MySqlManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.mysql").append("/").append("1.0.2");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new MySqlManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

