/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sybase.model;

import com.dbeaver.db.sybase.model.SybaseDataSource;
import com.dbeaver.db.sybase.model.SybaseTable;
import com.dbeaver.db.sybase.model.SybaseUser;
import java.sql.ResultSet;
import java.util.Collection;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class SybaseTablePrivilege
implements DBAPrivilege {
    private static final Log log = Log.getLog(SybaseTablePrivilege.class);
    private static final String NO_PERMISSION_SYMBOL = "N";
    private final SybaseTable table;
    private long grantee;
    private SybaseUser granteeUser;
    private long grantor;
    private SybaseUser grantorUser;
    private boolean select;
    private boolean insert;
    private boolean delete;
    private boolean update;
    private boolean updateCol;
    private boolean alter;
    private boolean reference;
    private boolean truncate;

    SybaseTablePrivilege(@NotNull SybaseTable table, @NotNull JDBCResultSet dbResult) {
        this.table = table;
        this.grantee = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"grantee");
        this.grantor = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"grantor");
        this.select = !NO_PERMISSION_SYMBOL.equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"selectauth"));
        this.insert = !NO_PERMISSION_SYMBOL.equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"insertauth"));
        this.delete = !NO_PERMISSION_SYMBOL.equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"deleteauth"));
        this.update = !NO_PERMISSION_SYMBOL.equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"updateauth"));
        this.updateCol = !NO_PERMISSION_SYMBOL.equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"updatecols"));
        this.alter = !NO_PERMISSION_SYMBOL.equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"alterauth"));
        this.reference = !NO_PERMISSION_SYMBOL.equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"referenceauth"));
        this.truncate = !NO_PERMISSION_SYMBOL.equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"truncateauth"));
    }

    @NotNull
    public SybaseTable getParentObject() {
        return this.table;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.table.getDataSource();
    }

    @Property(viewable=true, order=1)
    @Nullable
    public SybaseUser getGrantee(@NotNull DBRProgressMonitor monitor) {
        DBPDataSource dataSource;
        if (this.granteeUser == null && (dataSource = this.getDataSource()) instanceof SybaseDataSource) {
            try {
                Collection<SybaseUser> users = ((SybaseDataSource)dataSource).getUsers(monitor);
                this.granteeUser = users.stream().filter(u -> u.getUserId() == this.grantee).findFirst().orElse(null);
            }
            catch (DBException e) {
                log.error((Object)"Can't read users list from database", (Throwable)e);
            }
        }
        return this.granteeUser;
    }

    @Property(viewable=true, order=2)
    @Nullable
    public SybaseUser getGrantor(@NotNull DBRProgressMonitor monitor) {
        DBPDataSource dataSource;
        if (this.grantorUser == null && (dataSource = this.getDataSource()) instanceof SybaseDataSource) {
            try {
                Collection<SybaseUser> users = ((SybaseDataSource)dataSource).getUsers(monitor);
                this.grantorUser = users.stream().filter(u -> u.getUserId() == this.grantor).findFirst().orElse(null);
            }
            catch (DBException e) {
                log.error((Object)"Can't read users list from database", (Throwable)e);
            }
        }
        return this.grantorUser;
    }

    @Property(viewable=true, updatable=true, order=3)
    public boolean isSelect() {
        return this.select;
    }

    public void setSelect(boolean select) {
        this.select = select;
    }

    @Property(viewable=true, updatable=true, order=4)
    public boolean isInsert() {
        return this.insert;
    }

    public void setInsert(boolean insert) {
        this.insert = insert;
    }

    @Property(viewable=true, updatable=true, order=5)
    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @Property(viewable=true, updatable=true, order=6)
    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    @Property(viewable=true, order=7)
    public boolean isUpdateCol() {
        return this.updateCol;
    }

    @Property(viewable=true, updatable=true, order=8)
    public boolean isAlter() {
        return this.alter;
    }

    public void setAlter(boolean alter) {
        this.alter = alter;
    }

    @Property(viewable=true, order=9)
    public boolean isReference() {
        return this.reference;
    }

    @Property(viewable=true, updatable=true, order=10)
    public boolean isTruncate() {
        return this.truncate;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    @NotNull
    public String getName() {
        return String.valueOf(this.table.getName()) + "_" + this.grantee + "_" + this.grantor;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }
}

