/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sybase.model;

import com.dbeaver.db.sybase.model.SybaseSequence;
import com.dbeaver.db.sybase.model.SybaseTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericSchema;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericView;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerMetaModel;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SybaseMetaModel
extends SQLServerMetaModel {
    public SybaseMetaModel() {
        super(false);
    }

    public boolean isSqlServer() {
        return false;
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            return new SQLServerGenericView(container, tableName, tableType, dbResult);
        }
        return new SybaseTable(container, tableName, tableType, dbResult);
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT s.*, r.remarks FROM " + DBUtils.getQuotedIdentifier((DBSObject)container) + ".SYS.SYSSEQUENCE s LEFT JOIN SYS.SYSREMARK r ON s.object_id = r.object_id" + " WHERE owner = ? ORDER BY sequence_name");
        long schemaID = 0L;
        GenericSchema schema = container.getSchema();
        if (schema instanceof SQLServerGenericSchema) {
            schemaID = ((SQLServerGenericSchema)schema).getSchemaId();
        }
        dbStat.setLong(1, schemaID);
        return dbStat;
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"sequence_name");
        if (CommonUtils.isEmpty((String)name)) {
            return null;
        }
        String description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"remarks");
        return new SybaseSequence(container, name, description, null, CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"min_value")), CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"max_value")), CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"increment_by")), dbResult);
    }
}

