/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sybase.edit;

import com.dbeaver.db.sybase.model.SybaseTable;
import com.dbeaver.db.sybase.model.SybaseTablePrivilege;
import com.dbeaver.db.sybase.model.SybaseUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class SybaseTablePrivilegeManager
extends SQLObjectEditor<SybaseTablePrivilege, SybaseTable> {
    private static final String[] PERMISSIONS_KEYS = new String[]{"insert", "select", "delete", "update", "alter", "truncate"};

    public boolean canEditObject(SybaseTablePrivilege object) {
        return true;
    }

    public boolean canCreateObject(Object container) {
        return false;
    }

    public boolean canDeleteObject(SybaseTablePrivilege object) {
        return false;
    }

    protected SybaseTablePrivilege createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        throw new IllegalStateException("Not implemented");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        SybaseTablePrivilege privilege = (SybaseTablePrivilege)command.getObject();
        Map properties = command.getProperties();
        SybaseUser grantee = privilege.getGrantee(monitor);
        if (!CommonUtils.isEmpty((Map)properties) && grantee != null) {
            StringBuilder sql;
            ArrayList<String> grantList = new ArrayList<String>();
            ArrayList<String> revokeList = new ArrayList<String>();
            String[] stringArray = PERMISSIONS_KEYS;
            int n = PERMISSIONS_KEYS.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (properties.containsKey(key)) {
                    boolean insert = CommonUtils.getBoolean(properties.get(key), (boolean)false);
                    if (insert) {
                        grantList.add(key.toUpperCase(Locale.ENGLISH));
                    } else {
                        revokeList.add(key.toUpperCase(Locale.ENGLISH));
                    }
                }
                ++n2;
            }
            if (!grantList.isEmpty()) {
                sql = new StringBuilder("GRANT ");
                this.addPermissionsToSQL(grantList, sql);
                sql.append(" ON ").append(privilege.getParentObject().getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" TO ").append(grantee.getName());
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Grant permission(s)", sql.toString()));
            }
            if (!revokeList.isEmpty()) {
                sql = new StringBuilder("REVOKE ");
                this.addPermissionsToSQL(revokeList, sql);
                sql.append(" ON ").append(privilege.getParentObject().getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" FROM ").append(grantee.getName());
                actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Revoke permission(s)", sql.toString()));
            }
        }
    }

    private void addPermissionsToSQL(List<String> permissionsList, StringBuilder sql) {
        if (permissionsList.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            permissionsList.forEach(joiner::add);
            sql.append(joiner.toString());
        } else {
            sql.append(permissionsList.get(0));
        }
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, SybaseTablePrivilege> getObjectsCache(SybaseTablePrivilege object) {
        return null;
    }
}

