/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application.security;

import com.dbeaver.application.security.SecurityMethodDialog;
import com.dbeaver.ee.runtime.ui.security.EnterPasswordDialog;
import com.dbeaver.ee.runtime.ui.security.MainWindowProvider;
import com.dbeaver.ee.runtime.ui.security.NewPasswordDialog;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesContainer;
import org.eclipse.equinox.internal.security.ui.storage.StoragePreferencePage;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DBeaverPasswordProvider
extends PasswordProvider {
    private static final Log log = Log.getLog(DBeaverPasswordProvider.class);
    public static final String ID = "DBeaverPasswordProvider";
    public static final String MODULE_ID = "com.dbeaver.app.advanced.dbeaverpasswordprovider";

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
            log.error((Object)"WARNING: Master password requested in headless mode. As a workaround, use integrated password provider instead.");
            return null;
        }
        String[] password = new String[1];
        boolean[] tryAgain = new boolean[1];
        UIUtils.syncExec(() -> {
            try {
                stringArray[0] = this.getPasswordFromUI(passwordType);
            }
            catch (SecurityMethodWasChangedException securityMethodWasChangedException) {
                blArray[0] = true;
            }
        });
        if (tryAgain[0]) {
            SecurePreferencesContainer c = (SecurePreferencesContainer)container;
            try {
                PBEKeySpec pBEKeySpec = c.getRootData().getPassword(null, (IPreferencesContainer)c, true).getPassword();
                return pBEKeySpec;
            }
            catch (StorageException e) {
                log.error((Object)"Error requesting password from the integrated password provider", (Throwable)e);
            }
            finally {
                c.setOption((Object)"org.eclipse.equinox.security.storage.promptUser", (Object)Boolean.FALSE);
            }
        }
        if (password[0] == null) {
            return null;
        }
        return new PBEKeySpec(password[0].toCharArray());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String getPasswordFromUI(int passwordType) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (MainWindowProvider mainWindowProvider = new MainWindowProvider();){
            String password;
            boolean passwordChange;
            boolean newPassword = (passwordType & 1) != 0;
            boolean bl = passwordChange = (passwordType & 2) != 0;
            if (newPassword) {
                boolean fromPreferences = false;
                Shell[] shellArray = Display.getCurrent().getShells();
                int n = shellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    void dialog;
                    Shell shell = shellArray[n2];
                    Object object = shell.getData();
                    if (object instanceof PreferenceDialog var13_14 && dialog.getSelectedPage() instanceof StoragePreferencePage) {
                        fromPreferences = true;
                    }
                    ++n2;
                }
                if (!fromPreferences) {
                    SecurityMethodDialog dialog = new SecurityMethodDialog(mainWindowProvider.getActiveShell());
                    if (dialog.open() != 0) {
                        return null;
                    }
                    if (dialog.getMethod() == SecurityMethodDialog.SecurityMethod.INTEGRATED_SECURITY) {
                        throw new SecurityMethodWasChangedException();
                    }
                }
                password = NewPasswordDialog.getNewPassword((Shell)mainWindowProvider.getActiveShell(), (String)("Set " + GeneralUtils.getProductName() + " master password"), (String)"Set master password to save secure information", null);
            } else {
                password = passwordChange ? NewPasswordDialog.getNewPassword((Shell)mainWindowProvider.getActiveShell(), (String)"Change master password", null, null) : EnterPasswordDialog.askPassword((Shell)mainWindowProvider.getActiveShell(), (String)(String.valueOf(GeneralUtils.getProductName()) + " master password"), (String)(String.valueOf(GeneralUtils.getProductName()) + " master password"), null);
            }
            if (CommonUtils.isEmpty((String)password)) {
                return null;
            }
            return password;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean retryOnError(Exception e, IPreferencesContainer container) {
        if (e instanceof SecurityMethodWasChangedException) {
            return true;
        }
        boolean[] result = new boolean[1];
        UIUtils.syncExec(() -> {
            boolean reply;
            blArray[0] = reply = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Workspace master password", (String)"Incorrect password or data is corrupted. Would you like to re-log?");
        });
        return result[0];
    }

    private static class SecurityMethodWasChangedException
    extends RuntimeException {
        private SecurityMethodWasChangedException() {
        }
    }
}

