/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.application.EnterpriseActionBarAdvisor;
import com.dbeaver.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.ee.qm.internal.QMPluginService;
import com.dbeaver.lm.ui.LicenseManagerUIUtils;
import java.text.SimpleDateFormat;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionPrincipal;
import org.jkiss.dbeaver.model.qm.QMSessionInfo;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchWindowAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.CommandLineParameterHandler;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;

public class EnterpriseWorkbenchWindowAdvisor
extends ApplicationWorkbenchWindowAdvisor {
    private static final Log log = Log.getLog(EnterpriseWorkbenchWindowAdvisor.class);
    private static final int RC_NOT_LICENSED = 100;

    public EnterpriseWorkbenchWindowAdvisor(EnterpriseWorkbenchAdvisor advisor, IWorkbenchWindowConfigurer configurer) {
        super((ApplicationWorkbenchAdvisor)advisor, configurer);
    }

    public void postWindowOpen() {
        new AbstractJob("License check"){

            protected IStatus run(DBRProgressMonitor monitor) {
                LMLicense[] checkResult = new LMLicense[1];
                try {
                    Shell shell = EnterpriseWorkbenchWindowAdvisor.this.getWindowConfigurer().getWindow().getShell();
                    log.debug((Object)"Check product license");
                    checkResult[0] = LicenseManagerUIUtils.checkLicense((DBRProgressMonitor)monitor, (Shell)shell);
                }
                catch (Throwable e) {
                    DBWorkbench.getPlatformUI().showError("License check", "Error checking license information", e);
                }
                LMLicense curLicense = checkResult[0];
                if (curLicense == null) {
                    log.debug((Object)"No valid license found");
                    UIUtils.syncExec(() -> EnterpriseWorkbenchWindowAdvisor.this.getWindowConfigurer().getWorkbenchConfigurer().emergencyClose());
                    System.exit(100);
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                log.debug((Object)("License: " + curLicense.getLicenseId() + " (" + curLicense.getLicenseType().getDisplayName() + "; " + dateFormat.format(curLicense.getLicenseIssueTime()) + (curLicense.getLicenseEndTime() == null ? "" : " - " + dateFormat.format(curLicense.getLicenseEndTime())) + ")"));
                return Status.OK_STATUS;
            }
        }.schedule();
        new AbstractJob("Initialize global query manager session"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    this.initGlobalQMSession(monitor);
                }
                catch (DBException e) {
                    log.error((Object)"Failed to initialize query manager", (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public void initGlobalQMSession(DBRProgressMonitor monitor) throws DBException {
                SMSession session = QMUtils.getWorkspaceSession((DBRProgressMonitor)monitor);
                SMSessionPrincipal globalPrincipal = session.getSessionPrincipal();
                String userName = globalPrincipal.getUserName();
                String qmSessionId = QMPluginService.getQmService().openSession(new QMSessionInfo(userName, globalPrincipal.getUserDomain()));
                DBWorkbench.getPlatform().getPreferenceStore().setValue("qm_session_id", qmSessionId);
            }
        }.schedule();
        super.postWindowOpen();
    }

    protected boolean isRunWorkbenchInitializers() {
        return super.isRunWorkbenchInitializers();
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new EnterpriseActionBarAdvisor(configurer);
    }

    public static class LicenseParameterHandler
    implements CommandLineParameterHandler {
        public void handleParameter(CommandLine commandLine, String name, String value) {
            LMLicenseManager.setLicenseCustomPath((String)value);
        }
    }
}

