/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.models.SkuTier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class Sku {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Sku.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="tier")
    private SkuTier tier;
    @JsonProperty(value="capacity")
    private Integer capacity;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="family")
    private String family;

    public String name() {
        return this.name;
    }

    public Sku withName(String name) {
        this.name = name;
        return this;
    }

    public SkuTier tier() {
        return this.tier;
    }

    public Sku withTier(SkuTier tier) {
        this.tier = tier;
        return this;
    }

    public Integer capacity() {
        return this.capacity;
    }

    public Sku withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    public String size() {
        return this.size;
    }

    public Sku withSize(String size) {
        this.size = size;
        return this;
    }

    public String family() {
        return this.family;
    }

    public Sku withFamily(String family) {
        this.family = family;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Sku"));
        }
    }
}

