/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForDefaultCreate;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForGeoRestore;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForReplica;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForRestore;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="createMode", defaultImpl=ServerPropertiesForCreate.class)
@JsonTypeName(value="ServerPropertiesForCreate")
@JsonSubTypes(value={@JsonSubTypes.Type(name="Default", value=ServerPropertiesForDefaultCreate.class), @JsonSubTypes.Type(name="PointInTimeRestore", value=ServerPropertiesForRestore.class), @JsonSubTypes.Type(name="GeoRestore", value=ServerPropertiesForGeoRestore.class), @JsonSubTypes.Type(name="Replica", value=ServerPropertiesForReplica.class)})
public class ServerPropertiesForCreate {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerPropertiesForCreate.class);
    @JsonProperty(value="version")
    private ServerVersion version;
    @JsonProperty(value="sslEnforcement")
    private SslEnforcementEnum sslEnforcement;
    @JsonProperty(value="minimalTlsVersion")
    private MinimalTlsVersionEnum minimalTlsVersion;
    @JsonProperty(value="infrastructureEncryption")
    private InfrastructureEncryption infrastructureEncryption;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccessEnum publicNetworkAccess;
    @JsonProperty(value="storageProfile")
    private StorageProfile storageProfile;

    public ServerVersion version() {
        return this.version;
    }

    public ServerPropertiesForCreate withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public SslEnforcementEnum sslEnforcement() {
        return this.sslEnforcement;
    }

    public ServerPropertiesForCreate withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        this.sslEnforcement = sslEnforcement;
        return this;
    }

    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ServerPropertiesForCreate withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public InfrastructureEncryption infrastructureEncryption() {
        return this.infrastructureEncryption;
    }

    public ServerPropertiesForCreate withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        this.infrastructureEncryption = infrastructureEncryption;
        return this;
    }

    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ServerPropertiesForCreate withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ServerPropertiesForCreate withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }
}

