/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.models.VirtualNetworkRuleInner;
import com.azure.resourcemanager.postgresql.implementation.Utils;
import com.azure.resourcemanager.postgresql.models.VirtualNetworkRule;
import com.azure.resourcemanager.postgresql.models.VirtualNetworkRuleState;

public final class VirtualNetworkRuleImpl
implements VirtualNetworkRule,
VirtualNetworkRule.Definition,
VirtualNetworkRule.Update {
    private VirtualNetworkRuleInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String virtualNetworkRuleName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String virtualNetworkSubnetId() {
        return this.innerModel().virtualNetworkSubnetId();
    }

    @Override
    public Boolean ignoreMissingVnetServiceEndpoint() {
        return this.innerModel().ignoreMissingVnetServiceEndpoint();
    }

    @Override
    public VirtualNetworkRuleState state() {
        return this.innerModel().state();
    }

    @Override
    public VirtualNetworkRuleInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public VirtualNetworkRuleImpl withExistingServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public VirtualNetworkRule create() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualNetworkRules().createOrUpdate(this.resourceGroupName, this.serverName, this.virtualNetworkRuleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public VirtualNetworkRule create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualNetworkRules().createOrUpdate(this.resourceGroupName, this.serverName, this.virtualNetworkRuleName, this.innerModel(), context);
        return this;
    }

    VirtualNetworkRuleImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new VirtualNetworkRuleInner();
        this.serviceManager = serviceManager;
        this.virtualNetworkRuleName = name;
    }

    @Override
    public VirtualNetworkRuleImpl update() {
        return this;
    }

    @Override
    public VirtualNetworkRule apply() {
        this.innerObject = this.serviceManager.serviceClient().getVirtualNetworkRules().createOrUpdate(this.resourceGroupName, this.serverName, this.virtualNetworkRuleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public VirtualNetworkRule apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getVirtualNetworkRules().createOrUpdate(this.resourceGroupName, this.serverName, this.virtualNetworkRuleName, this.innerModel(), context);
        return this;
    }

    VirtualNetworkRuleImpl(VirtualNetworkRuleInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = Utils.getValueFromIdByName(innerObject.id(), "servers");
        this.virtualNetworkRuleName = Utils.getValueFromIdByName(innerObject.id(), "virtualNetworkRules");
    }

    @Override
    public VirtualNetworkRule refresh() {
        this.innerObject = (VirtualNetworkRuleInner)((Object)this.serviceManager.serviceClient().getVirtualNetworkRules().getWithResponse(this.resourceGroupName, this.serverName, this.virtualNetworkRuleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public VirtualNetworkRule refresh(Context context) {
        this.innerObject = (VirtualNetworkRuleInner)((Object)this.serviceManager.serviceClient().getVirtualNetworkRules().getWithResponse(this.resourceGroupName, this.serverName, this.virtualNetworkRuleName, context).getValue());
        return this;
    }

    @Override
    public VirtualNetworkRuleImpl withVirtualNetworkSubnetId(String virtualNetworkSubnetId) {
        this.innerModel().withVirtualNetworkSubnetId(virtualNetworkSubnetId);
        return this;
    }

    @Override
    public VirtualNetworkRuleImpl withIgnoreMissingVnetServiceEndpoint(Boolean ignoreMissingVnetServiceEndpoint) {
        this.innerModel().withIgnoreMissingVnetServiceEndpoint(ignoreMissingVnetServiceEndpoint);
        return this;
    }
}

