/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.models.DatabaseInner;
import com.azure.resourcemanager.postgresql.implementation.Utils;
import com.azure.resourcemanager.postgresql.models.Database;

public final class DatabaseImpl
implements Database,
Database.Definition,
Database.Update {
    private DatabaseInner innerObject;
    private final PostgreSqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String databaseName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String charset() {
        return this.innerModel().charset();
    }

    @Override
    public String collation() {
        return this.innerModel().collation();
    }

    @Override
    public DatabaseInner innerModel() {
        return this.innerObject;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseImpl withExistingServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public Database create() {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().createOrUpdate(this.resourceGroupName, this.serverName, this.databaseName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Database create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().createOrUpdate(this.resourceGroupName, this.serverName, this.databaseName, this.innerModel(), context);
        return this;
    }

    DatabaseImpl(String name, PostgreSqlManager serviceManager) {
        this.innerObject = new DatabaseInner();
        this.serviceManager = serviceManager;
        this.databaseName = name;
    }

    @Override
    public DatabaseImpl update() {
        return this;
    }

    @Override
    public Database apply() {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().createOrUpdate(this.resourceGroupName, this.serverName, this.databaseName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Database apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabases().createOrUpdate(this.resourceGroupName, this.serverName, this.databaseName, this.innerModel(), context);
        return this;
    }

    DatabaseImpl(DatabaseInner innerObject, PostgreSqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = Utils.getValueFromIdByName(innerObject.id(), "servers");
        this.databaseName = Utils.getValueFromIdByName(innerObject.id(), "databases");
    }

    @Override
    public Database refresh() {
        this.innerObject = (DatabaseInner)((Object)this.serviceManager.serviceClient().getDatabases().getWithResponse(this.resourceGroupName, this.serverName, this.databaseName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Database refresh(Context context) {
        this.innerObject = (DatabaseInner)((Object)this.serviceManager.serviceClient().getDatabases().getWithResponse(this.resourceGroupName, this.serverName, this.databaseName, context).getValue());
        return this;
    }

    @Override
    public DatabaseImpl withCharset(String charset) {
        this.innerModel().withCharset(charset);
        return this;
    }

    @Override
    public DatabaseImpl withCollation(String collation) {
        this.innerModel().withCollation(collation);
        return this;
    }
}

