/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model.data;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.data.gis.handlers.WKGUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.geojson.GeoJsonReader;

public class SnowflakeGeometryValueHandler
extends JDBCAbstractValueHandler {
    public static final SnowflakeGeometryValueHandler INSTANCE = new SnowflakeGeometryValueHandler();

    private SnowflakeGeometryValueHandler() {
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    @Nullable
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, @Nullable Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof DBGeometry && copy) {
            return ((DBGeometry)object).copy();
        }
        if (object instanceof String) {
            String data = (String)object;
            if (data.startsWith("{")) {
                try {
                    return new DBGeometry(new GeoJsonReader().read(data));
                }
                catch (ParseException e) {
                    throw new DBCException("Error reading GeoJSON geometry", (Throwable)e);
                }
            }
            return WKGUtils.parseWKT((String)data);
        }
        if (object instanceof byte[]) {
            try {
                return new DBGeometry(new WKBReader().read((byte[])object));
            }
            catch (ParseException e) {
                throw new DBCException("Error reading WKB geometry", (Throwable)e);
            }
        }
        throw new DBCException("Unexpected value: " + object);
    }

    @Nullable
    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return this.getValueFromObject(session, type, resultSet.getObject(index), false, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject type, int index, Object value) throws SQLException {
        if (value == null) {
            statement.setNull(index, type.getTypeID());
        } else {
            DBGeometry geometry = (DBGeometry)value;
            String string = geometry.getSRID() != 0 ? "SRID=" + geometry.getSRID() + ";" + geometry : geometry.toString();
            statement.setString(index, string);
        }
    }
}

