/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model.auth;

import com.dbeaver.db.snowflake.model.auth.SnowflakeAuthModelPrivateKeyCredentials;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import java.util.Properties;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.snowflake.model.auth.AuthModelSnowflakeCredentials;
import org.jkiss.dbeaver.ext.snowflake.model.auth.SnowflakeAuthModelSnowflake;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SnowflakeAuthModelPrivateKey
extends SnowflakeAuthModelSnowflake<SnowflakeAuthModelPrivateKeyCredentials> {
    private static final Log log = Log.getLog(SnowflakeAuthModelPrivateKey.class);
    public static final String PROP_AUTH_PRIVATE_KEY = "private-key";
    public static final String PROP_AUTH_PRIVATE_KEY_PASSWORD = "private-ley-password";

    @NotNull
    public SnowflakeAuthModelPrivateKeyCredentials createCredentials() {
        return new SnowflakeAuthModelPrivateKeyCredentials();
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull SnowflakeAuthModelPrivateKeyCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        String privateKey = DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser() ? this.decodePrivateKey(credentials.getEncodedPrivateKey()) : this.getPrivateKeyFromPath(credentials.getEncodedPrivateKey());
        if (CommonUtils.isEmpty((String)privateKey)) {
            throw new DBException("Private key is missing");
        }
        String passphrase = credentials.getPassphrase();
        try {
            connProperties.put("privateKey", PrivateKeyReader.get(privateKey, CommonUtils.notEmpty((String)passphrase)));
        }
        catch (Exception e) {
            throw new DBException("Error reading private key from credentials", (Throwable)e);
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelSnowflakeCredentials)credentials, configuration, connProperties);
    }

    @NotNull
    public SnowflakeAuthModelPrivateKeyCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        SnowflakeAuthModelPrivateKeyCredentials credentials = (SnowflakeAuthModelPrivateKeyCredentials)super.loadCredentials(dataSource, configuration);
        credentials.setEncodedPrivateKey(CommonUtils.notEmpty((String)configuration.getAuthProperty(PROP_AUTH_PRIVATE_KEY)));
        credentials.setPassphrase(CommonUtils.notEmpty((String)configuration.getAuthProperty(PROP_AUTH_PRIVATE_KEY_PASSWORD)));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull SnowflakeAuthModelPrivateKeyCredentials credentials) {
        configuration.setAuthProperty(PROP_AUTH_PRIVATE_KEY, credentials.getEncodedPrivateKey());
        configuration.setAuthProperty(PROP_AUTH_PRIVATE_KEY_PASSWORD, credentials.getPassphrase());
        super.saveCredentials(dataSource, configuration, (AuthModelSnowflakeCredentials)credentials);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }

    protected String getAuthenticator(DBPDataSource dataSource, AuthModelDatabaseNativeCredentials credentials, DBPConnectionConfiguration configuration) {
        return null;
    }

    @NotNull
    private String getPrivateKeyFromPath(String privateKeyPath) throws DBException {
        try {
            return Files.readString(Path.of(privateKeyPath, new String[0]));
        }
        catch (Exception e) {
            throw new DBException("Error reading private key from '" + privateKeyPath + "'", (Throwable)e);
        }
    }

    @NotNull
    private String decodePrivateKey(@NotNull String encodedKey) {
        byte[] bytes = Base64.getDecoder().decode(encodedKey);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    static class PrivateKeyReader {
        PrivateKeyReader() {
        }

        static PrivateKey get(@NotNull String privateKey, @NotNull String passphrase) throws Exception {
            PrivateKeyInfo privateKeyInfo = null;
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
            Object pemObject = pemParser.readObject();
            if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObject;
                InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(passphrase.toCharArray());
                privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(pkcs8Prov);
            } else if (pemObject instanceof PrivateKeyInfo) {
                privateKeyInfo = (PrivateKeyInfo)pemObject;
            } else {
                throw new DBException("No private key pair found.\nFound: " + pemObject);
            }
            pemParser.close();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            return converter.getPrivateKey(privateKeyInfo);
        }
    }
}

