/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.exec;

import com.dbeaver.db.couchbase.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase.exec.CouchbaseQueryStatementN1;
import com.dbeaver.db.couchbase.model.CouchbaseBucket;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class CouchbaseSession
extends AbstractSession {
    private static final Log log = Log.getLog(CouchbaseSession.class);
    private final CouchbaseExecutionContext executionContext;
    private CouchbaseBucket sessionBucket;

    public CouchbaseSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, CouchbaseExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
    }

    @NotNull
    public CouchbaseExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public CouchbaseDataSource getDataSource() {
        return (CouchbaseDataSource)this.executionContext.getDataSource();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        CouchbaseBucket bucket = this.getSessionBucket();
        return new CouchbaseQueryStatementN1(this, bucket, query);
    }

    private CouchbaseBucket getSessionBucket() throws DBCException {
        if (this.sessionBucket == null) {
            try {
                this.sessionBucket = ((CouchbaseDataSource)this.executionContext.getDataSource()).getDefaultBucket(this.getProgressMonitor());
            }
            catch (DBException e) {
                throw new DBCException("", (Throwable)e);
            }
        }
        return this.sessionBucket;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread != null) {
            blockThread.interrupt();
        } else if (this.sessionBucket != null) {
            this.sessionBucket.close();
        }
    }

    public void close() {
        super.close();
    }
}

