/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security;

import com.dbeaver.model.security.CustomNameService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;

class DynamicNameServiceHandler
implements InvocationHandler {
    private CustomNameService cns;
    private Object defaultNameService;

    public DynamicNameServiceHandler(CustomNameService cns) {
        this.cns = cns;
    }

    void setParent(Object defaultNameService) {
        this.defaultNameService = defaultNameService;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        switch (method.getName()) {
            case "lookupAllHostAddr": {
                InetAddress[] result = this.cns.lookupAllHostAddr((String)args[0]);
                if (result == null) {
                    if (!method.canAccess(this.defaultNameService)) {
                        method.setAccessible(true);
                    }
                    try {
                        result = (InetAddress[])method.invoke(this.defaultNameService, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                return result;
            }
            case "getHostByAddr": {
                String result = this.cns.getHostByAddr((byte[])args[0]);
                if (result == null) {
                    if (!method.canAccess(this.defaultNameService)) {
                        method.setAccessible(true);
                    }
                    try {
                        result = (String)method.invoke(this.defaultNameService, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                return result;
            }
        }
        StringBuilder o = new StringBuilder();
        o.append(method.getReturnType().getCanonicalName()).append(" ").append(method.getName()).append("(");
        Class<?>[] ps = method.getParameterTypes();
        int i = 0;
        while (i < ps.length) {
            if (i > 0) {
                o.append(", ");
            }
            o.append(ps[i].getCanonicalName()).append(" p").append(i);
            ++i;
        }
        o.append(")");
        throw new UnsupportedOperationException(o.toString());
    }
}

