/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security;

import com.dbeaver.model.security.DynamicNameServiceHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public interface CustomNameService {
    public InetAddress[] lookupAllHostAddr(String var1) throws UnknownHostException;

    public String getHostByAddr(byte[] var1) throws UnknownHostException;

    public static void install(CustomNameService dns) throws Exception {
        List<Object> newNameService;
        Field nameServiceField;
        Class<?> iface;
        Class<InetAddress> inetAddressClass = InetAddress.class;
        DynamicNameServiceHandler proxy = new DynamicNameServiceHandler(dns);
        try {
            iface = Class.forName("java.net.InetAddress$NameService");
            nameServiceField = inetAddressClass.getDeclaredField("nameService");
            newNameService = Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)proxy);
        }
        catch (ClassNotFoundException | NoSuchFieldException reflectiveOperationException) {
            nameServiceField = inetAddressClass.getDeclaredField("nameServices");
            iface = Class.forName("sun.net.spi.nameservice.NameService");
            newNameService = List.of(Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)proxy));
        }
        nameServiceField.setAccessible(true);
        Object defaultNameService = nameServiceField.get(inetAddressClass);
        proxy.setParent(defaultNameService);
        nameServiceField.set(inetAddressClass, newNameService);
    }
}

