/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class CustomHostsConfig {
    private static final Log log = Log.getLog(CustomHostsConfig.class);
    private static final String HOSTS_FILE_NAME = "dbeaver-hosts.conf";
    private static final String DEFAULT_HOSTS_CONFIG = "# This is a custom HOSTS file used by DBeaver.\n#\n# It has higher priority than system hosts configuration\n#";
    public static final String JDK_HOSTS_PROP_NAME = "jdk.net.hosts.file";
    private static Path hostsFile;

    public static void defineCustomHosts() {
        hostsFile = GeneralUtils.getMetadataFolder().resolve(HOSTS_FILE_NAME);
        if (!Files.exists(hostsFile, new LinkOption[0])) {
            try {
                CustomHostsConfig.writeDefaultHostsConfig();
            }
            catch (IOException e) {
                log.error((Object)"Error creating hosts configuration", (Throwable)e);
                return;
            }
        }
        System.setProperty(JDK_HOSTS_PROP_NAME, hostsFile.toAbsolutePath().toString());
    }

    public static void addHostMapping(String address, String hostName, String anchor) {
    }

    public static void removeHostMapping(String address, String hostName, String anchor) {
    }

    private static void writeDefaultHostsConfig() throws IOException {
        Files.writeString(hostsFile, (CharSequence)DEFAULT_HOSTS_CONFIG, new OpenOption[0]);
    }
}

