/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.document.data;

import com.dbeaver.model.document.data.DBDocumentUtils;
import com.dbeaver.model.document.data.DBMapElement;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.struct.AbstractDataType;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeDynamic;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.utils.CommonUtils;

public class DBMapValue<DATASOURCE extends DBPDataSource>
extends AbstractDataType<DATASOURCE>
implements DBDComposite,
DBDValueCloneable {
    private static final Log log = Log.getLog(DBMapValue.class);
    @Nullable
    private final Object parent;
    @Nullable
    private Map<String, Object> contents;
    private boolean modified;

    public DBMapValue(@NotNull DATASOURCE dataSource, @Nullable Object parent, @Nullable Map<String, Object> sourceData) {
        super(dataSource);
        this.parent = parent;
        this.contents = sourceData;
    }

    public DBMapValue(@NotNull DATASOURCE dataSource, @Nullable Map<String, Object> sourceData) {
        this(dataSource, null, sourceData);
    }

    public DBMapValue(@NotNull DBMapValue<DATASOURCE> source, @Nullable Object parent) {
        super(source.getDataSource());
        this.parent = parent;
        this.contents = source.contents == null ? null : new LinkedHashMap<String, Object>(source.contents);
    }

    public Map<String, Object> getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void release() {
        this.contents = null;
    }

    @NotNull
    public String getTypeName() {
        return "##map";
    }

    public int getTypeID() {
        return 2;
    }

    public DBPDataKind getDataKind() {
        return DBPDataKind.STRUCT;
    }

    public DBSDataType getDataType() {
        return this;
    }

    @Nullable
    public DBSDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return DBDocumentUtils.getDocumentDataType(this.getDataSource(), 11);
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        if (this.contents == null || this.contents.isEmpty()) {
            return new DBSAttributeBase[0];
        }
        Set<String> keySet = this.contents.keySet();
        MapAttribute[] attrs = new MapAttribute[keySet.size()];
        int index = 0;
        for (String key : keySet) {
            attrs[index] = new MapAttribute(this, index, key, this.contents.get(key));
            ++index;
        }
        return attrs;
    }

    @Nullable
    public Object getAttributeValue(@NotNull String attributeName) {
        return this.contents == null ? null : this.contents.get(attributeName);
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) {
        return this.contents == null ? null : this.contents.get(attribute.getName());
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object value) throws DBCException {
        if (this.contents == null) {
            this.contents = new LinkedHashMap<String, Object>();
        }
        this.contents.put(attribute.getName(), value);
        this.modified = true;
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) throws DBCException {
        return new DBMapValue<DATASOURCE>(this, null);
    }

    @Nullable
    public Object getParent() {
        return this.parent;
    }

    public String toString() {
        return CommonUtils.toString((Object)this.getRawValue());
    }

    public String toJson() {
        return DBDocumentUtils.convertValueToJson(this.getDataSource(), this.contents);
    }

    private static MapValueType getMapValueTypeFromValue(Object value) {
        if (value == null) {
            return MapValueType.NULL;
        }
        if (value instanceof CharSequence) {
            return MapValueType.STRING;
        }
        if (value instanceof Boolean) {
            return MapValueType.BOOLEAN;
        }
        if (value instanceof Number) {
            return MapValueType.NUMBER;
        }
        if (value instanceof Date || value instanceof Instant) {
            return MapValueType.DATETIME;
        }
        if (value instanceof Collection) {
            return MapValueType.ARRAY;
        }
        if (value instanceof Map || value instanceof DBMapValue) {
            return MapValueType.MAP;
        }
        return MapValueType.OBJECT;
    }

    public static class MapAttribute<DATASOURCE extends DBPDataSource>
    implements DBSAttributeDynamic,
    DBMapElement<DATASOURCE> {
        private final DBMapValue<DATASOURCE> mapValue;
        String name;
        int position;
        MapValueType valueType;

        MapAttribute(DBMapValue<DATASOURCE> mapValue, int index, String name, Object value) {
            this.mapValue = mapValue;
            this.position = index;
            this.name = name;
            this.valueType = DBMapValue.getMapValueTypeFromValue(value);
        }

        @Property(viewable=true, order=1)
        @NotNull
        public String getName() {
            return this.name;
        }

        @Property(viewable=true, order=2)
        public int getOrdinalPosition() {
            return this.position;
        }

        @Property(viewable=true, order=3)
        public String getTypeName() {
            return this.valueType.name();
        }

        public String getFullTypeName() {
            return this.getTypeName();
        }

        public int getTypeID() {
            return this.valueType.ordinal();
        }

        public DBPDataKind getDataKind() {
            return this.valueType.getDataKind();
        }

        public Integer getScale() {
            return null;
        }

        public Integer getPrecision() {
            return null;
        }

        public long getMaxLength() {
            return 0L;
        }

        public long getTypeModifiers() {
            return 0L;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapAttribute)) {
                return false;
            }
            MapAttribute attr = (MapAttribute)obj;
            return CommonUtils.equalObjects((Object)this.name, (Object)attr.name) && this.valueType == attr.valueType && this.position == attr.position;
        }

        public int hashCode() {
            return this.name.hashCode() + this.valueType.ordinal() + this.position;
        }

        public String toString() {
            return String.valueOf(this.name) + "; " + this.position;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        @Override
        public DBMapValue<DATASOURCE> getContainer() {
            return this.mapValue;
        }

        public boolean isDynamicAttribute() {
            return true;
        }
    }

    public static enum MapValueType {
        NULL(DBPDataKind.ANY),
        STRING(DBPDataKind.STRING),
        NUMBER(DBPDataKind.NUMERIC),
        BOOLEAN(DBPDataKind.BOOLEAN),
        DATETIME(DBPDataKind.DATETIME),
        ARRAY(DBPDataKind.ARRAY),
        MAP(DBPDataKind.STRUCT),
        OBJECT(DBPDataKind.OBJECT);

        private final DBPDataKind dataKind;

        private MapValueType(DBPDataKind dataKind) {
            this.dataKind = dataKind;
        }

        public DBPDataKind getDataKind() {
            return this.dataKind;
        }
    }
}

