/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.auth;

import com.dbeaver.model.auth.SMFederatedAuthProvider;
import com.dbeaver.model.auth.SMSessionAuthCredentials;
import com.dbeaver.model.auth.SMSessionRemote;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.auth.SMAuthConfigurationReference;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class SMAuthUtils {
    @Nullable
    public static Map<String, Object> getCredentialsFromSession(@NotNull SMSession mainSession, @NotNull String providerId) {
        List<SMAuthInfo> subAuthList;
        SMSessionRemote sessionRemote = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)mainSession);
        if (sessionRemote != null && (subAuthList = sessionRemote.getAuthInfos()) != null) {
            for (SMAuthInfo sai : subAuthList) {
                Map<String, Object> creds = SMAuthUtils.getProviderCredentialsFromAuthInfo(sai, providerId);
                if (creds == null) continue;
                return creds;
            }
        }
        return null;
    }

    @Nullable
    private static Map<String, Object> getProviderCredentialsFromAuthInfo(SMAuthInfo info, @NotNull String providerId) {
        Map authData = info.getAuthData();
        for (Map.Entry entry : authData.entrySet()) {
            if (!providerId.equals(((SMAuthConfigurationReference)entry.getKey()).getAuthProviderId()) || !(entry.getValue() instanceof Map)) continue;
            return (Map)entry.getValue();
        }
        return null;
    }

    public static boolean updateSessionCredentialsFromSession(@NotNull DBRProgressMonitor monitor, @NotNull String authContextType, @NotNull String authSpaceTitle, @NotNull SMSessionAuthCredentials credentials) throws DBException {
        SMFederatedAuthProvider federatedAuthProvider = (SMFederatedAuthProvider)DBUtils.getAdapter(SMFederatedAuthProvider.class, (Object)DBWorkbench.getPlatform().getApplication());
        if (federatedAuthProvider == null) {
            return false;
        }
        return federatedAuthProvider.updateFederatedCredentialsFromSession(monitor, authContextType, authSpaceTitle, credentials);
    }
}

