/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresqlflexibleserver.PostgreSqlManager;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.ConfigurationsClient;
import com.azure.resourcemanager.postgresqlflexibleserver.fluent.models.ConfigurationInner;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.ConfigurationImpl;
import com.azure.resourcemanager.postgresqlflexibleserver.implementation.Utils;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Configuration;
import com.azure.resourcemanager.postgresqlflexibleserver.models.Configurations;

public final class ConfigurationsImpl
implements Configurations {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationsImpl.class);
    private final ConfigurationsClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ConfigurationsImpl(ConfigurationsClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<Configuration> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ConfigurationInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new ConfigurationImpl((ConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<Configuration> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ConfigurationInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new ConfigurationImpl((ConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<Configuration> getWithResponse(String resourceGroupName, String serverName, String configurationName, Context context) {
        Response<ConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, configurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ConfigurationImpl((ConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public Configuration get(String resourceGroupName, String serverName, String configurationName) {
        ConfigurationInner inner = this.serviceClient().get(resourceGroupName, serverName, configurationName);
        if (inner != null) {
            return new ConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Configuration getById(String id) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String configurationName = Utils.getValueFromIdByName(id, "configurations");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurations'.", id)));
        }
        return (Configuration)this.getWithResponse(resourceGroupName, serverName, configurationName, Context.NONE).getValue();
    }

    @Override
    public Response<Configuration> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = Utils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serverName = Utils.getValueFromIdByName(id, "flexibleServers");
        if (serverName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'flexibleServers'.", id)));
        }
        String configurationName = Utils.getValueFromIdByName(id, "configurations");
        if (configurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'configurations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serverName, configurationName, context);
    }

    private ConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationImpl define(String name) {
        return new ConfigurationImpl(name, this.manager());
    }
}

