/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.part;

import com.dbeaver.ee.vqb.VQBEditorUtils;
import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.part.QueryJoinEditPolicy;
import com.dbeaver.model.sql.vqb.model.VQBJoinType;
import java.util.List;
import net.sf.jsqlparser.statement.select.Join;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.ui.figures.RoundedLineBorder;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.policy.AssociationBendEditPolicy;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;

public class QueryJoinPart
extends AssociationPart
implements IMenuListener {
    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new AssociationBendEditPolicy());
        if (this.isEditEnabled()) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new QueryJoinEditPolicy());
        }
    }

    private void updateVisibility() {
        this.getFigure().setVisible(this.isVisibleJoin());
    }

    protected void refreshVisuals() {
        this.updateVisibility();
        super.refreshVisuals();
    }

    protected void setConnectionStyles(PolylineConnection conn) {
        conn.setVisible(this.isVisibleJoin());
        conn.setLineWidth(2);
        ConnectionLocator joinLabelLocator = new ConnectionLocator((Connection)conn, 4);
        Label iconLabel = new Label(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
        conn.add((IFigure)iconLabel, (Object)joinLabelLocator);
        RoundedLineBorder iconBorder = new RoundedLineBorder(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.lines.foreground"), 2, 5);
        iconBorder.setMargin(3);
        iconLabel.setBorder((Border)iconBorder);
        iconLabel.setOpaque(true);
    }

    private boolean isVisibleJoin() {
        VQBJoinType joinType = this.getJoinType();
        return joinType == VQBJoinType.SIMPLE || joinType == VQBJoinType.CROSS || joinType == VQBJoinType.NATURAL || this.getAssociation().getTargetAttributes().size() != 0 || this.getAssociation().getSourceAttributes().size() != 0;
    }

    @NotNull
    private DBIcon getJoinIcon() {
        return this.getJoinType().getIcon();
    }

    @NotNull
    private VQBJoinType getJoinType() {
        Join join = (Join)this.getAssociation().getUserData();
        if (join != null) {
            return VQBJoinType.getByJoin((Join)join);
        }
        return VQBJoinType.SIMPLE;
    }

    private void setJoinType(@NotNull VQBJoinType joinType) {
        Join join = (Join)this.getAssociation().getUserData();
        if (join != null) {
            joinType.setJoinType(join);
        }
    }

    protected void setConnectionToolTip(PolylineConnection conn) {
        Join join = (Join)this.getAssociation().getUserData();
        if (join != null) {
            Label toolTip = new Label(join.toString());
            toolTip.setBorder((Border)new MarginBorder(3));
            toolTip.setIcon(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
            toolTip.setTextPlacement(8);
            conn.setToolTip((IFigure)toolTip);
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            VQBEditorPart editorPart = VQBEditorUtils.getQueryBuilderEditor((EditPart)this);
            editorPart.getPresentation().getQueryPanel().editElement("joins", this.getAssociation().getUserData());
        } else {
            super.performRequest(request);
        }
    }

    public void menuAboutToShow(@NotNull IMenuManager menu) {
        DBSObject sourceEntity = (DBSObject)this.getAssociation().getSourceEntity().getObject();
        DBSObject targetEntity = (DBSObject)this.getAssociation().getTargetEntity().getObject();
        final VQBJoinType oldJoinType = this.getJoinType();
        menu.add((IAction)new Action(NLS.bind((String)VQBMessages.editor_panel_joins_select_all_rows_from_table, (Object)DBUtils.getObjectFullName((DBPNamedObject)sourceEntity, (DBPEvaluationContext)DBPEvaluationContext.UI)), 2){

            public void run() {
                QueryJoinPart.this.setJoinType(QueryJoinPart.combineJoinType(oldJoinType, VQBJoinType.LEFT, !this.isChecked()));
                QueryJoinPart.this.getEditorPart().scheduleQueryGenerator();
            }

            public boolean isChecked() {
                return QueryJoinPart.isIncludeDataFromLeftTable(oldJoinType);
            }
        });
        menu.add((IAction)new Action(NLS.bind((String)VQBMessages.editor_panel_joins_select_all_rows_from_table, (Object)DBUtils.getObjectFullName((DBPNamedObject)targetEntity, (DBPEvaluationContext)DBPEvaluationContext.UI)), 2){

            public void run() {
                QueryJoinPart.this.setJoinType(QueryJoinPart.combineJoinType(oldJoinType, VQBJoinType.RIGHT, !this.isChecked()));
                QueryJoinPart.this.getEditorPart().scheduleQueryGenerator();
            }

            public boolean isChecked() {
                return QueryJoinPart.isIncludeDataFromRightTable(oldJoinType);
            }
        });
        menu.add((IContributionItem)new Separator());
    }

    public void updateJoinType() {
        List children = this.getFigure().getChildren();
        if (children.size() == 1 && children.get(0) instanceof Label) {
            Label iconLabel = (Label)children.get(0);
            iconLabel.setIcon(DBeaverIcons.getImage((DBPImage)this.getJoinIcon()));
        }
    }

    @NotNull
    private VQBEditorPart getEditorPart() {
        return (VQBEditorPart)this.getDiagramPart().getEditor();
    }

    private static boolean isIncludeDataFromLeftTable(@NotNull VQBJoinType type) {
        return type == VQBJoinType.LEFT || type == VQBJoinType.FULL_OUTER;
    }

    private static boolean isIncludeDataFromRightTable(@NotNull VQBJoinType type) {
        return type == VQBJoinType.RIGHT || type == VQBJoinType.FULL_OUTER;
    }

    @NotNull
    private static VQBJoinType combineJoinType(@NotNull VQBJoinType oldJoinType, @NotNull VQBJoinType newJoinType, boolean include) {
        boolean right;
        boolean left = QueryJoinPart.isIncludeDataFromLeftTable(newJoinType) ? include : QueryJoinPart.isIncludeDataFromLeftTable(oldJoinType);
        boolean bl = right = QueryJoinPart.isIncludeDataFromRightTable(newJoinType) ? include : QueryJoinPart.isIncludeDataFromRightTable(oldJoinType);
        if (left && right) {
            return VQBJoinType.FULL_OUTER;
        }
        if (left) {
            return VQBJoinType.LEFT;
        }
        if (right) {
            return VQBJoinType.RIGHT;
        }
        return VQBJoinType.INNER;
    }
}

