/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.ui.editor.VQBEditPartFactory;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPart;
import com.dbeaver.ee.vqb.ui.editor.VQBSelectionTool;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.ui.editor.ERDViewStyle;
import org.jkiss.dbeaver.erd.ui.model.ERDDecoratorDefault;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;

public class VQBEditorDecorator
extends ERDDecoratorDefault {
    private static final Log log = Log.getLog(VQBEditorDecorator.class);
    private final VQBEditorPart editorPart;

    public VQBEditorDecorator(VQBEditorPart editorPart) {
        this.editorPart = editorPart;
    }

    public boolean showCheckboxes() {
        return true;
    }

    public boolean supportsAttributeStyle(@NotNull ERDViewStyle style) {
        return style == ERDViewStyle.ALPHABETICAL_ORDER;
    }

    public boolean supportsAttributeVisibility() {
        return false;
    }

    public boolean supportsStructureEdit() {
        return false;
    }

    @NotNull
    public Insets getDefaultEntityInsets() {
        return new Insets(30, 40, 20, 40);
    }

    @NotNull
    public EditPartFactory createPartFactory() {
        return new VQBEditPartFactory();
    }

    public void fillPalette(@NotNull PaletteRoot paletteRoot, boolean readOnly) {
        PaletteDrawer toolsDrawer = this.createToolsDrawer(paletteRoot);
        SelectionToolEntry selectionTool = new SelectionToolEntry();
        selectionTool.setToolClass(VQBSelectionTool.class);
        toolsDrawer.add((PaletteEntry)selectionTool);
        CreationFactory factory = new CreationFactory(){

            public Object getNewObject() {
                return new ERDEntity(VQBEditorDecorator.this.editorPart.getDataSource());
            }

            public Object getObjectType() {
                return "create child";
            }
        };
        CreationToolEntry tableAddTool = new CreationToolEntry("Add Table", "Add joined table", factory, DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE), DBeaverIcons.getImageDescriptor((DBPImage)DBIcon.TREE_TABLE));
        toolsDrawer.add((PaletteEntry)tableAddTool);
        paletteRoot.setDefaultEntry((ToolEntry)selectionTool);
    }
}

