/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.VQBFeatures;
import com.dbeaver.ee.vqb.ui.commands.VQBDiagramCommand;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.erd.ui.command.AssociationCreateCommand;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.utils.CommonUtils;

public class JoinCreateCommand
extends AssociationCreateCommand
implements VQBDiagramCommand {
    private final ERDDiagram entityDiagram;
    private final VQBQueryInfo queryInfo;

    public JoinCreateCommand(ERDDiagram entityDiagram, VQBQueryInfo queryInfo) {
        this.entityDiagram = entityDiagram;
        this.queryInfo = queryInfo;
    }

    protected ERDAssociation createAssociation(ERDElement<?> sourceEntity, ERDElement<?> targetEntity, boolean reflect) {
        if (sourceEntity instanceof ERDEntity && targetEntity instanceof ERDEntity) {
            ERDJoin erdJoin = new ERDJoin((ERDEntity)sourceEntity, (ERDEntity)targetEntity, reflect);
            if (this.getSourceAttribute() != null && this.getTargetAttribute() != null) {
                erdJoin.addCondition(this.getSourceAttribute(), this.getTargetAttribute());
            }
            return erdJoin;
        }
        return null;
    }

    public boolean canExecute() {
        if (this.getSourceAttribute() == null || this.getTargetAttribute() == null || CommonUtils.equalObjects((Object)this.getSourceAttribute(), (Object)this.getTargetAttribute()) || ((ERDEntity)this.targetEntity).isPrimary()) {
            return false;
        }
        return this.getSourceEntity() instanceof ERDEntity && this.getTargetEntity() instanceof ERDEntity;
    }

    public void execute() {
        this.association = this.execute(false);
        VQBFeatures.VQB_ADD_JOIN.use();
    }

    public void undo() {
        VQBUtils.deleteJoin((ERDDiagram)this.entityDiagram, (ERDAssociation)this.association, (PlainSelect)this.queryInfo.getPlainSelect());
        this.association = null;
    }

    private ERDJoin execute(boolean undo) {
        ERDJoin erdJoin = null;
        PlainSelect plainSelect = this.queryInfo.getPlainSelect();
        if (plainSelect != null) {
            if (!undo) {
                Join join = VQBUtils.findEntityJoin((ERDDiagram)this.entityDiagram, (PlainSelect)plainSelect, (ERDEntity)((ERDEntity)this.sourceEntity), (ERDEntity)((ERDEntity)this.targetEntity));
                ERDEntityAttribute sourceAttribute = this.getSourceAttribute();
                ERDEntityAttribute targetAttribute = this.getTargetAttribute();
                if (join != null) {
                    erdJoin = VQBUtils.findERDJoin((ERDDiagram)this.entityDiagram, (Join)join);
                    if (erdJoin == null) {
                        erdJoin = new ERDJoin((ERDEntity)this.sourceEntity, (ERDEntity)this.targetEntity, true);
                        erdJoin.addCondition(sourceAttribute, targetAttribute);
                        erdJoin.setUserData((Object)join);
                        join = erdJoin.createStatementJoin();
                        join.setInner(true);
                        VQBUtils.getQueryJoins((PlainSelect)plainSelect).add(join);
                    } else {
                        if (!(erdJoin.getSourceEntity().equals((Object)this.sourceEntity) && erdJoin.getTargetEntity().equals((Object)this.targetEntity) || !join.isSimple())) {
                            this.updateERDJoin(erdJoin);
                            erdJoin.getTargetAttributes().clear();
                            erdJoin.getSourceAttributes().clear();
                        }
                        if (erdJoin.getSourceEntity() == this.targetEntity && erdJoin.getTargetEntity() == this.sourceEntity || erdJoin.getSourceEntity().getAttribute((DBSEntityAttribute)sourceAttribute.getObject()) == null) {
                            ERDEntityAttribute tmpAttribute = targetAttribute;
                            targetAttribute = sourceAttribute;
                            sourceAttribute = tmpAttribute;
                        }
                    }
                    if (!erdJoin.getSourceAttributes().contains(sourceAttribute) || !erdJoin.getTargetAttributes().contains(targetAttribute)) {
                        if (join.isSimple()) {
                            join.setSimple(false);
                            join.setInner(true);
                        }
                        erdJoin.addCondition(sourceAttribute, targetAttribute);
                        erdJoin.updateStatementJoin(join);
                    }
                } else {
                    erdJoin = new ERDJoin((ERDEntity)this.sourceEntity, (ERDEntity)this.targetEntity, true);
                    erdJoin.addCondition(sourceAttribute, targetAttribute);
                    join = erdJoin.createStatementJoin();
                    join.setInner(true);
                    VQBUtils.getQueryJoins((PlainSelect)plainSelect).add(join);
                }
            } else {
                erdJoin = (ERDJoin)this.association;
            }
        }
        return erdJoin;
    }

    private void updateERDJoin(ERDJoin erdJoin) {
        erdJoin.getTargetEntity().removeReferenceAssociation((ERDAssociation)erdJoin, true);
        erdJoin.getSourceEntity().removeAssociation((ERDAssociation)erdJoin, true);
        erdJoin.setSourceEntity(this.sourceEntity);
        erdJoin.setTargetEntity(this.targetEntity);
        erdJoin.getSourceEntity().addAssociation((ERDAssociation)erdJoin, true);
        erdJoin.getTargetEntity().addReferenceAssociation((ERDAssociation)erdJoin, true);
    }
}

