/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryQualifiedName;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryValueExpression;

public class SQLQuerySelectionResultModel {
    private final List<ResultSublistSpec> sublists;

    public SQLQuerySelectionResultModel(int capacity) {
        this.sublists = new ArrayList<ResultSublistSpec>(capacity);
    }

    public void addColumnSpec(@NotNull SQLQueryValueExpression valueExpression) {
        this.sublists.add(new ColumnSpec(valueExpression));
    }

    public void addColumnSpec(@NotNull SQLQueryValueExpression valueExpression, @Nullable SQLQuerySymbolEntry alias) {
        this.sublists.add(new ColumnSpec(valueExpression, alias));
    }

    public void addTupleSpec(@NotNull SQLQueryQualifiedName tableName) {
        this.sublists.add(new TupleSpec(tableName));
    }

    public void addCompleteTupleSpec() {
        this.sublists.add(new CompleteTupleSpec());
    }

    public List<SQLQuerySymbol> expandColumns(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        return this.sublists.stream().flatMap(s -> s.expand(context, statistics)).collect(Collectors.toList());
    }

    private class ColumnSpec
    extends ResultSublistSpec {
        private final SQLQueryValueExpression valueExpression;
        private final SQLQuerySymbolEntry alias;

        public ColumnSpec(SQLQueryValueExpression valueExpression) {
            this(valueExpression, null);
        }

        public ColumnSpec(@Nullable SQLQueryValueExpression valueExpression, SQLQuerySymbolEntry alias) {
            this.valueExpression = valueExpression;
            this.alias = alias;
        }

        @Override
        @NotNull
        protected Stream<SQLQuerySymbol> expand(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
            SQLQuerySymbol columnName;
            this.valueExpression.propagateContext(context, statistics);
            if (this.alias != null) {
                columnName = this.alias.getSymbol();
                columnName.setDefinition(this.alias);
                columnName.setSymbolClass(SQLQuerySymbolClass.COLUMN_DERIVED);
            } else {
                columnName = this.valueExpression.getColumnNameIfTrivialExpression();
                if (columnName == null) {
                    columnName = new SQLQuerySymbol("?");
                }
            }
            return Stream.of(columnName);
        }
    }

    private class CompleteTupleSpec
    extends ResultSublistSpec {
        @Override
        @NotNull
        protected Stream<SQLQuerySymbol> expand(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
            return context.getColumnsList().stream();
        }
    }

    private abstract class ResultSublistSpec {
        private ResultSublistSpec() {
        }

        @NotNull
        protected abstract Stream<SQLQuerySymbol> expand(@NotNull SQLQueryDataContext var1, @NotNull SQLQueryRecognitionContext var2);
    }

    private class TupleSpec
    extends ResultSublistSpec {
        private final SQLQueryQualifiedName tableName;

        public TupleSpec(SQLQueryQualifiedName tableName) {
            this.tableName = tableName;
        }

        @Override
        @NotNull
        protected Stream<SQLQuerySymbol> expand(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
            SourceResolutionResult rr = context.resolveSource(this.tableName.toListOfStrings());
            if (rr != null) {
                this.tableName.setDefinition(rr);
                return rr.source.getDataContext().getColumnsList().stream();
            }
            this.tableName.setSymbolClass(SQLQuerySymbolClass.ERROR);
            statistics.appendError(this.tableName.entityName, "The table doesn't participate in this subquery context");
            return Stream.empty();
        }
    }
}

