/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;

public class SQLQueryRowsCorrelatedSourceModel
extends SQLQueryRowsSourceModel {
    private final SQLQueryRowsSourceModel source;
    private final SQLQuerySymbolEntry alias;
    private final List<SQLQuerySymbolEntry> correlationColumNames;

    public SQLQueryRowsCorrelatedSourceModel(@NotNull SQLQueryRowsSourceModel source, @NotNull SQLQuerySymbolEntry alias, @NotNull List<SQLQuerySymbolEntry> correlationColumNames) {
        this.source = source;
        this.alias = alias;
        this.correlationColumNames = correlationColumNames;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        context = this.source.propagateContext(context, statistics).extendWithTableAlias(this.alias.getSymbol(), this.source);
        this.alias.getSymbol().setDefinition(this.alias);
        this.alias.getSymbol().setSymbolClass(SQLQuerySymbolClass.TABLE_ALIAS);
        if (this.correlationColumNames.size() > 0) {
            ArrayList<SQLQuerySymbol> columns = new ArrayList<SQLQuerySymbol>(context.getColumnsList());
            int i = 0;
            while (i < columns.size() && i < this.correlationColumNames.size()) {
                SQLQuerySymbolEntry correlatedNameDef = this.correlationColumNames.get(i);
                SQLQuerySymbol correlatedName = correlatedNameDef.getSymbol();
                correlatedNameDef.setDefinition(((SQLQuerySymbol)columns.get(i)).getDefinition());
                correlatedName.setDefinition(correlatedNameDef);
                columns.set(i, correlatedName);
                ++i;
            }
            context = context.overrideResultTuple(columns);
        }
        return context;
    }
}

