/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics.context;

import java.util.List;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryAliasedRowsContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryCombinedContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryPureResultTupleContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryResultTupleContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SQLQueryTableRowsContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;

public abstract class SQLQueryDataContext {
    public abstract List<SQLQuerySymbol> getColumnsList();

    public abstract DBSEntity findRealTable(List<String> var1);

    public abstract SQLQuerySymbolDefinition resolveColumn(String var1);

    public SourceResolutionResult resolveSource(List<String> tableName) {
        DBSEntity table = this.findRealTable(tableName);
        SQLQueryRowsSourceModel source = this.findRealSource(table);
        return source == null ? null : SourceResolutionResult.forRealTableByName(source, table);
    }

    public abstract SQLQueryRowsSourceModel findRealSource(DBSEntity var1);

    public final SQLQueryDataContext overrideResultTuple(List<SQLQuerySymbol> columns) {
        return new SQLQueryResultTupleContext(this, columns);
    }

    public final SQLQueryDataContext combine(SQLQueryDataContext other) {
        return new SQLQueryCombinedContext(this, other);
    }

    public final SQLQueryDataContext extendWithRealTable(DBSEntity table, SQLQueryRowsSourceModel source) {
        return new SQLQueryTableRowsContext(this, table, source);
    }

    public final SQLQueryDataContext extendWithTableAlias(SQLQuerySymbol alias, SQLQueryRowsSourceModel source) {
        return new SQLQueryAliasedRowsContext(this, alias, source);
    }

    public final SQLQueryDataContext hideSources() {
        return new SQLQueryPureResultTupleContext(this);
    }

    public abstract SQLDialect getDialect();

    public abstract SQLQueryRowsSourceModel getDefaultTable();
}

