/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.krb5;

import com.dbeaver.ui.auth.krb5.AuthModelKerberosMessages;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.kerby.kerberos.kerb.client.KrbClient;
import org.apache.kerby.kerberos.kerb.client.KrbConfig;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ConfigurationFileSelector;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;

public class AuthModelKerberosConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private static final Log log = Log.getLog(AuthModelKerberosConfigurator.class);
    private static final String SHOW_SERVICE_NAME = "krb5.show-service";
    private static final String SHOW_SSL_JKS = "krb5.show-ssl-jks";
    private final String HELP_WIKI_LINK = "Kerberos-Authentication";
    private Text kerberosUserText;
    private Text realmText;
    private Text kdcServerText;
    private Button krb5DebugCheckbox;
    private Button kinitCheckbox;
    private TextWithOpenFile keyCacheText;
    private TextWithOpenFile keytabText;
    private Button keytabCheckbox;
    private Button sslJksCheckbox;
    private TextWithOpenFile sslJksText;
    private Text sslJksPassword;
    private Label serviceNameTextLabel;
    private Text serviceNameText;
    private Button customConfCheck;
    private TextWithOpenFile customConfText;

    public void createControl(final @NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        Composite kerberosGroup = parent;
        Dialog.applyDialogFont((Control)kerberosGroup);
        Label usernameLabel = UIUtils.createLabel((Composite)kerberosGroup, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        usernameLabel.setLayoutData((Object)new GridData(32));
        Composite userNamePanel = UIUtils.createComposite((Composite)kerberosGroup, (int)2);
        userNamePanel.setLayoutData((Object)new GridData(768));
        this.usernameText = new Text(userNamePanel, 2048);
        this.usernameText.setLayoutData((Object)new GridData(768));
        this.usernameText.addModifyListener(e -> propertyChangeListener.run());
        Link urlHelpLabel = UIUtils.createLink((Composite)userNamePanel, (String)("<a>" + AuthModelKerberosMessages.model_kerberos_wiki_link_message + "</a>"), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"Kerberos-Authentication"));
            }
        });
        GridData gridData = new GridData(4, 0x1000008, true, true);
        urlHelpLabel.setLayoutData((Object)gridData);
        this.kerberosUserText = UIUtils.createLabelText((Composite)kerberosGroup, (String)AuthModelKerberosMessages.model_kerberos_user, null, (int)2048);
        this.kerberosUserText.setToolTipText(AuthModelKerberosMessages.model_kerberos_user_help);
        GridData gdt = new GridData(768);
        gdt.widthHint = UIUtils.getFontHeight((Control)this.kerberosUserText) * 20;
        this.kerberosUserText.setLayoutData((Object)gdt);
        this.realmText = UIUtils.createLabelText((Composite)kerberosGroup, (String)AuthModelKerberosMessages.model_kerberos_realm, null);
        this.realmText.setToolTipText(AuthModelKerberosMessages.model_kerberos_realm_help);
        GridData gdt2 = new GridData(768);
        gdt2.widthHint = UIUtils.getFontHeight((Control)this.realmText) * 20;
        this.realmText.setLayoutData((Object)gdt2);
        this.kdcServerText = UIUtils.createLabelText((Composite)kerberosGroup, (String)AuthModelKerberosMessages.model_kerberos_kdc_server, null, (int)2048, (Object)new GridData(768));
        this.createPasswordControls(kerberosGroup, propertyChangeListener);
        ExpandableComposite serverComp = new ExpandableComposite(kerberosGroup, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        serverComp.setLayoutData((Object)gd);
        serverComp.setText("Extra configuration");
        serverComp.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                UIUtils.resizeShell((Shell)parent.getShell());
            }
        });
        Composite extraConfigPanel = UIUtils.createComposite((Composite)serverComp, (int)2);
        serverComp.setClient((Control)extraConfigPanel);
        this.kinitCheckbox = UIUtils.createCheckbox((Composite)extraConfigPanel, (String)AuthModelKerberosMessages.model_kerberos_use_kinit, (String)AuthModelKerberosMessages.model_kerberos_use_kinit_help, (boolean)false, (int)1);
        this.kinitCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelKerberosConfigurator.this.updateKerberosSettingsVisibility();
            }
        });
        this.keyCacheText = new ConfigurationFileSelector(extraConfigPanel, "Key cache file path", new String[0]);
        this.keyCacheText.setLayoutData((Object)new GridData(256));
        String defaultCachePath = String.valueOf(System.getProperty("user.home")) + File.separator + "krb5cc_" + CommonUtils.trim((String)System.getProperty("user.name"));
        this.keyCacheText.getTextControl().setMessage(defaultCachePath);
        this.keytabCheckbox = UIUtils.createCheckbox((Composite)extraConfigPanel, (boolean)false);
        this.keytabCheckbox.setText(AuthModelKerberosMessages.model_kerberos_use_keytab);
        this.keytabCheckbox.setToolTipText(AuthModelKerberosMessages.model_kerberos_use_keytab_help);
        this.keytabCheckbox.setLayoutData((Object)new GridData(32));
        this.keytabCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelKerberosConfigurator.this.updateKerberosSettingsVisibility();
            }
        });
        this.keytabText = new ConfigurationFileSelector(extraConfigPanel, AuthModelKerberosMessages.model_kerberos_keytab_path, new String[]{"*.*"});
        this.keytabText.setLayoutData((Object)new GridData(256));
        UIUtils.addVariablesToControl((Control)this.keytabText.getTextControl(), (String[])this.getAvailableVariables(), (String)"Key tab pattern");
        this.customConfCheck = UIUtils.createCheckbox((Composite)extraConfigPanel, (String)"Custom krb5.conf", (String)"Custom krb5.conf (or krb5.ini) file path", (boolean)false, (int)1);
        this.customConfText = new ConfigurationFileSelector(extraConfigPanel, "Custom krb5conf file path", new String[]{"*.conf", "*.ini", "*.*"});
        this.customConfText.setLayoutData((Object)new GridData(768));
        this.customConfCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelKerberosConfigurator.this.updateKerberosSettingsVisibility();
            }
        });
        this.serviceNameTextLabel = UIUtils.createControlLabel((Composite)extraConfigPanel, (String)AuthModelKerberosMessages.model_kerberos_service_name);
        this.serviceNameText = new Text(extraConfigPanel, 2048);
        this.serviceNameText.setLayoutData((Object)new GridData(768));
        this.serviceNameText.setToolTipText(AuthModelKerberosMessages.model_kerberos_service_name_help);
        this.sslJksCheckbox = UIUtils.createCheckbox((Composite)extraConfigPanel, (boolean)false);
        this.sslJksCheckbox.setText(AuthModelKerberosMessages.model_kerberos_use_ssl);
        this.sslJksCheckbox.setToolTipText(AuthModelKerberosMessages.model_kerberos_use_ssl_help);
        this.sslJksCheckbox.setLayoutData((Object)new GridData(256));
        this.sslJksCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelKerberosConfigurator.this.updateKerberosSettingsVisibility();
            }
        });
        Composite sslJksGroup = UIUtils.createComposite((Composite)extraConfigPanel, (int)3);
        sslJksGroup.setLayoutData((Object)new GridData(768));
        this.sslJksText = new ConfigurationFileSelector(sslJksGroup, AuthModelKerberosMessages.model_kerberos_ssl_jks_path, new String[]{"*.jks"}, true);
        this.sslJksText.setLayoutData((Object)new GridData(768));
        this.sslJksText.setToolTipText(AuthModelKerberosMessages.model_kerberos_ssl_jks_path_help);
        this.sslJksPassword = UIUtils.createLabelText((Composite)sslJksGroup, (String)AuthModelKerberosMessages.model_kerberos_ssl_jks_password, null, (int)0x400800, (Object)new GridData(768));
        this.krb5DebugCheckbox = UIUtils.createCheckbox((Composite)extraConfigPanel, (String)AuthModelKerberosMessages.model_kerberos_debug, (String)AuthModelKerberosMessages.model_kerberos_debug_help, (boolean)false, (int)2);
        Control infoLabel = UIUtils.createInfoLabel((Composite)kerberosGroup, (String)AuthModelKerberosMessages.model_kerberos_info_message, (int)1808, (int)2);
        GridData gridData2 = new GridData(4, 0x1000008, true, true);
        gridData2.horizontalSpan = 2;
        infoLabel.setLayoutData((Object)gridData2);
    }

    private void updateKerberosSettingsVisibility() {
        boolean kinit = this.kinitCheckbox.getSelection();
        this.keyCacheText.setEnabled(kinit);
        this.keyCacheText.getTextControl().setEnabled(kinit);
        this.customConfText.setEnabled(this.customConfCheck.getSelection());
        if (!kinit) {
            boolean keytab = this.keytabCheckbox.getSelection();
            this.showKeytabCheckbox(true);
            this.showKeytabText(keytab);
            this.showPassword(!keytab);
            this.kerberosUserText.setEnabled(true);
            this.realmText.setEnabled(true);
        } else {
            this.showKeytabText(false);
            this.showKeytabCheckbox(false);
            this.showPassword(false);
            this.kerberosUserText.setEnabled(false);
            this.realmText.setEnabled(false);
        }
        boolean ssl = this.sslJksCheckbox.getSelection();
        this.sslJksPassword.setEnabled(ssl);
        this.sslJksText.setEnabled(ssl);
        this.sslJksText.getTextControl().setEnabled(ssl);
    }

    private void showPassword(boolean show) {
        this.passwordText.setEnabled(show);
        this.savePasswordCheck.setEnabled(show);
        this.userManagementToolbar.setEnabled(show);
    }

    private void showKeytabCheckbox(boolean show) {
        this.keytabCheckbox.setEnabled(show);
    }

    private void showKeytabText(boolean show) {
        this.keytabText.setEnabled(show);
        this.kinitCheckbox.setEnabled(!show);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        List kdcs;
        KrbClient client;
        super.loadSettings(dataSource);
        String realm = null;
        String kdcServer = null;
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        realm = configuration.getAuthProperty("krb5.realm");
        try {
            client = new KrbClient();
        }
        catch (Exception e) {
            log.warn((Object)"Kerberos config was ignored, using empty config", (Throwable)e);
            client = new KrbClient(new KrbConfig());
        }
        KrbConfig config = client.getKrbConfig();
        if (realm == null) {
            realm = config.getDefaultRealm();
        }
        if ((kdcServer = configuration.getAuthProperty("krb5.kdc_server")) == null && realm != null && (kdcs = config.getRealmSectionItems(realm, "kdc")) != null && kdcs.size() > 0 && kdcs.get(0) != null) {
            kdcServer = kdcs.get(0).toString();
        }
        this.realmText.setText(CommonUtils.notEmpty((String)realm));
        this.kdcServerText.setText(CommonUtils.notEmpty((String)kdcServer));
        this.krb5DebugCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("krb5.debug")));
        this.kerberosUserText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("krb5.user")));
        this.keytabCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("krb5.use_keytab")));
        this.keytabText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("krb5.keytab_path")));
        this.kinitCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("krb5.use_kinit")));
        this.keyCacheText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("krb5.kinit_cache_file")));
        this.serviceNameText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("SERVICE_NAME")));
        this.sslJksCheckbox.setSelection(CommonUtils.toBoolean((Object)configuration.getAuthProperty("USE_SSL_JKS")));
        this.sslJksPassword.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("SSL_JKS_PASSWORD")));
        this.sslJksText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("SSL_JKS_PATH")));
        this.customConfText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("krb5.conf.path")));
        this.customConfCheck.setSelection(!this.customConfText.getText().isEmpty());
        boolean showSslJks = CommonUtils.getBoolean((Object)dataSource.getDriver().getDriverParameter(SHOW_SSL_JKS), (boolean)Boolean.FALSE);
        boolean showService = CommonUtils.getBoolean((Object)dataSource.getDriver().getDriverParameter(SHOW_SERVICE_NAME), (boolean)Boolean.FALSE);
        if (!showService) {
            this.serviceNameText.setVisible(false);
            ((GridData)this.serviceNameText.getLayoutData()).exclude = true;
            this.serviceNameText.getParent().getParent().layout(true, true);
            this.serviceNameTextLabel.setVisible(false);
            ((GridData)this.serviceNameTextLabel.getLayoutData()).exclude = true;
            this.serviceNameTextLabel.getParent().getParent().layout(true, true);
        }
        if (!showSslJks) {
            this.sslJksCheckbox.setVisible(false);
            ((GridData)this.sslJksCheckbox.getLayoutData()).exclude = true;
            this.sslJksCheckbox.getParent().getParent().layout(true, true);
            this.sslJksText.getParent().setVisible(false);
            ((GridData)this.sslJksText.getParent().getLayoutData()).exclude = true;
            this.sslJksText.getParent().getParent().layout(true, true);
        }
        this.updateKerberosSettingsVisibility();
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("krb5.realm", this.realmText.getText());
        props.put("krb5.kdc_server", this.kdcServerText.getText());
        props.put("krb5.debug", String.valueOf(this.krb5DebugCheckbox.getSelection()));
        props.put("krb5.user", this.kerberosUserText.getText());
        props.put("krb5.use_keytab", String.valueOf(this.keytabCheckbox.getSelection()));
        props.put("krb5.keytab_path", this.keytabText.getText());
        props.put("krb5.use_kinit", String.valueOf(this.kinitCheckbox.getSelection()));
        props.put("krb5.kinit_cache_file", String.valueOf(this.keyCacheText.getText()));
        props.put("USE_SSL_JKS", String.valueOf(this.sslJksCheckbox.getSelection()));
        props.put("SERVICE_NAME", this.serviceNameText.getText());
        props.put("SSL_JKS_PASSWORD", this.sslJksPassword.getText());
        props.put("SSL_JKS_PATH", this.sslJksText.getText());
        if (this.customConfCheck.getSelection()) {
            props.put("krb5.conf.path", String.valueOf(this.customConfText.getText()));
        }
        configuration.setAuthProperties(props);
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
    }

    public boolean isComplete() {
        return true;
    }

    @NotNull
    private String[] getAvailableVariables() {
        return (String[])Arrays.stream(DBPConnectionConfiguration.INTERNAL_CONNECT_VARIABLES).map(x -> x[0]).toArray(String[]::new);
    }
}

