/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.lm.LMByteArrayOutputStream;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMGroupUser;
import org.jkiss.lm.LMLicenseFormat;
import org.jkiss.lm.LMLicenseRole;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMProductRelease;
import org.jkiss.lm.LMRole;
import org.jkiss.lm.LMSerializable;
import org.jkiss.lm.LMStatusDetails;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class LMLicense
implements LMSerializable {
    private static final Logger log = Logger.getLogger("LMLicense");
    private static final long DAY_MS = 86400000L;
    public static final long FLAG_NONE = 0L;
    public static final long FLAG_ROLE_BASED = 1L;
    public static final long FLAG_CANCELED = 2L;
    public static final long FLAG_RESELLER = 4L;
    public static final long FLAG_SUBSCRIPTION = 8L;
    public static final long FLAG_LIMITED = 16L;
    public static final long FLAG_LIMITED_VERSION = 32L;
    public static final long FLAG_SERVER_LICENSE = 64L;
    public static final long FLAG_UNLIMITED_USERS = 256L;
    public static final long FLAG_UNLIMITED_TIME = 512L;
    public static final long FLAG_UNLIMITED_SERVERS = 1024L;
    public static final long FLAG_MULTI_INSTANCE = 2048L;
    public static final byte UPDATE_HASH_FORMAT_SIMPLE = 1;
    private byte[] encoded;
    private final String licenseId;
    private final LMLicenseType licenseType;
    private final Date licenseIssueTime;
    private final Date licenseStartTime;
    private final Date licenseEndTime;
    private long flags;
    private final String productId;
    private final String productVersion;
    private final String ownerId;
    private final String ownerCompany;
    private final String ownerName;
    private String ownerEmail;
    private byte yearsNumber;
    private byte reserved1;
    private short usersNumber;
    private short serversNumber;
    private final List<LMLicenseRole> roles = new ArrayList<LMLicenseRole>();
    private final List<LMGroupUser> groupUsers = new ArrayList<LMGroupUser>();
    private LMLicenseFormat licenseFormat;
    private LMStatusDetails remoteStatus;

    public LMLicense(@NotNull byte[] encryptedData, @NotNull Key key) throws LMException {
        int i;
        ByteBuffer buffer;
        this.encoded = encryptedData;
        try {
            buffer = ByteBuffer.wrap(LMEncryption.decrypt(encryptedData, key));
        }
        catch (LMException e) {
            throw new LMException("Corrupted license text:\n" + e.getMessage());
        }
        try {
            this.licenseFormat = LMLicenseFormat.valueOf(buffer.get());
        }
        catch (Exception exception) {
            log.warning("Unsupported license format: " + buffer.get(0));
            this.licenseFormat = LMLicenseFormat.STANDARD;
        }
        if (buffer.capacity() < this.licenseFormat.getEncryptedLength()) {
            throw new LMException("Bad " + this.licenseFormat + " license length (" + buffer.capacity() + ")");
        }
        this.licenseId = LMUtils.getStringFromBuffer(buffer, 16);
        this.licenseType = LMLicenseType.valueOf(buffer.get());
        this.licenseIssueTime = LMUtils.getDateFromBuffer(buffer);
        this.licenseStartTime = LMUtils.getDateFromBuffer(buffer);
        this.licenseEndTime = LMUtils.getDateFromBuffer(buffer);
        this.flags = buffer.getLong();
        if (!this.isMultiInstance() && buffer.capacity() != this.licenseFormat.getEncryptedLength()) {
            throw new LMException("Bad " + this.licenseFormat + " license length (" + buffer.capacity() + ")");
        }
        this.productId = LMUtils.getStringFromBuffer(buffer, 16);
        this.productVersion = LMUtils.getStringFromBuffer(buffer, 8);
        this.ownerId = LMUtils.getStringFromBuffer(buffer, 16);
        this.ownerCompany = LMUtils.getStringFromBuffer(buffer, 64);
        if (this.licenseFormat == LMLicenseFormat.STANDARD) {
            this.ownerName = LMUtils.getStringFromBuffer(buffer, 64);
        } else {
            this.ownerName = LMUtils.getStringFromBuffer(buffer, 32);
            this.ownerEmail = LMUtils.getStringFromBuffer(buffer, 48);
            this.yearsNumber = (byte)Math.max(1, buffer.get());
            this.reserved1 = buffer.get();
            this.usersNumber = (short)Math.max(1, buffer.getShort());
        }
        if (this.licenseFormat == LMLicenseFormat.ADVANCED) {
            buffer.get();
            buffer.get();
            int roleCount = buffer.get();
            i = 0;
            while (i < roleCount) {
                String roleId = LMUtils.getStringFromBuffer(buffer, 16);
                try {
                    LMRole lmRole = LMRole.valueOf(roleId);
                    int userCount = buffer.getInt();
                    LMLicenseRole role = new LMLicenseRole(lmRole, userCount);
                    this.roles.add(role);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.severe("Role '" + roleId + "' not recognized");
                }
                ++i;
            }
        }
        if (this.isMultiInstance()) {
            buffer.get();
            buffer.get();
            this.setServersNumber((short)Math.max(1, buffer.getShort()));
            int usersSize = buffer.getInt();
            i = 0;
            while (i < usersSize) {
                block17: {
                    buffer.get();
                    String userEmail = LMUtils.getStringFromBuffer(buffer, 128);
                    String userName = LMUtils.getStringFromBuffer(buffer, 128);
                    LMRole licenseRole = null;
                    if (this.licenseFormat == LMLicenseFormat.ADVANCED) {
                        String roleId = LMUtils.getStringFromBuffer(buffer, 16);
                        try {
                            licenseRole = LMRole.valueOf(roleId);
                        }
                        catch (Exception exception) {
                            log.severe("Role '" + roleId + "' not recognized for user " + userEmail);
                            break block17;
                        }
                    }
                    LMGroupUser groupUser = new LMGroupUser(userEmail, userName, licenseRole);
                    this.groupUsers.add(groupUser);
                }
                ++i;
            }
        }
    }

    public LMLicense(@NotNull String licenseId, @NotNull LMLicenseType licenseType, Date licenseIssueTime, Date licenseStartTime, Date licenseEndTime, long flags, String productId, String productVersion, String ownerId, String ownerCompany, String ownerName, String ownerEmail) {
        this.licenseFormat = (flags & 1L) != 0L ? LMLicenseFormat.ADVANCED : LMLicenseFormat.EXTENDED;
        this.licenseId = licenseId;
        this.licenseType = licenseType;
        this.licenseIssueTime = licenseIssueTime;
        this.licenseStartTime = licenseStartTime;
        this.licenseEndTime = licenseEndTime;
        this.flags = flags;
        this.productId = productId;
        this.productVersion = productVersion;
        this.ownerId = ownerId;
        this.ownerCompany = ownerCompany;
        this.ownerName = ownerName;
        this.ownerEmail = ownerEmail;
        this.yearsNumber = 1;
        this.reserved1 = 0;
        this.usersNumber = 1;
    }

    public byte[] getEncoded() {
        return this.encoded;
    }

    @Override
    @NotNull
    public LMLicenseFormat getFormat() {
        return this.licenseFormat;
    }

    public void setLicenseFormat(LMLicenseFormat licenseFormat) {
        this.licenseFormat = licenseFormat;
    }

    @NotNull
    public String getLicenseId() {
        return this.licenseId;
    }

    @NotNull
    public LMLicenseType getLicenseType() {
        return this.licenseType;
    }

    @NotNull
    public Date getLicenseIssueTime() {
        return this.licenseIssueTime;
    }

    @NotNull
    public Date getLicenseStartTime() {
        return this.licenseStartTime;
    }

    @Nullable
    public Date getLicenseEndTime() {
        if (this.licenseEndTime == null && this.licenseType == LMLicenseType.ACADEMIC) {
            return new Date(this.licenseStartTime.getTime() + 31536000000L);
        }
        return this.licenseEndTime;
    }

    public Date getCalculatedLicenseEndTime() {
        Date licenseEndTime = this.getLicenseEndTime();
        if (licenseEndTime == null) {
            licenseEndTime = new Date(this.licenseStartTime.getTime() + 86400000L * (long)this.getYearsNumber() * 365L);
        }
        return licenseEndTime;
    }

    public long getFlags() {
        return this.flags;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    @NotNull
    public String getProductId() {
        return this.productId;
    }

    @NotNull
    public String getProductVersion() {
        return this.productVersion;
    }

    @NotNull
    public String getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerCompany() {
        return this.ownerCompany;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    @NotNull
    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public byte getYearsNumber() {
        return this.yearsNumber;
    }

    public void setYearsNumber(byte yearsNumber) {
        this.yearsNumber = yearsNumber;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public short getUsersNumber() {
        return this.usersNumber;
    }

    public void setUsersNumber(short usersNumber) {
        this.usersNumber = usersNumber;
    }

    public void setServersNumber(short serversNumber) {
        this.serversNumber = serversNumber;
    }

    public short getServersNumber() {
        return this.serversNumber;
    }

    public List<LMLicenseRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<LMLicenseRole> roles) {
        this.roles.clear();
        this.roles.addAll(roles);
    }

    public void setGroupUsers(List<LMGroupUser> groupUsers) {
        this.groupUsers.clear();
        this.groupUsers.addAll(groupUsers);
    }

    public List<LMGroupUser> getGroupUsers() {
        return this.groupUsers;
    }

    public String getOwnerFull() {
        String licensedTo = this.ownerName;
        if (!CommonUtils.isEmpty((String)this.ownerCompany)) {
            licensedTo = String.valueOf(this.ownerCompany) + " / " + licensedTo;
        }
        return licensedTo;
    }

    @Override
    @NotNull
    public byte[] getData() {
        LMByteArrayOutputStream outBuffer = new LMByteArrayOutputStream(this.licenseFormat.getEncryptedLength());
        outBuffer.write(this.licenseFormat.getId());
        LMUtils.writeStringToBuffer(outBuffer, this.licenseId, 16);
        outBuffer.write(this.licenseType.getId());
        LMUtils.writeDateToBuffer(outBuffer, this.licenseIssueTime);
        LMUtils.writeDateToBuffer(outBuffer, this.licenseStartTime);
        LMUtils.writeDateToBuffer(outBuffer, this.licenseEndTime);
        LMUtils.writeLongToBuffer(outBuffer, this.flags);
        LMUtils.writeStringToBuffer(outBuffer, this.productId, 16);
        LMUtils.writeStringToBuffer(outBuffer, this.productVersion, 8);
        LMUtils.writeStringToBuffer(outBuffer, this.ownerId, 16);
        LMUtils.writeStringToBuffer(outBuffer, this.ownerCompany, 64);
        if (this.licenseFormat == LMLicenseFormat.STANDARD) {
            LMUtils.writeStringToBuffer(outBuffer, this.ownerName, 64);
        } else {
            LMUtils.writeStringToBuffer(outBuffer, this.ownerName, 32);
            LMUtils.writeStringToBuffer(outBuffer, this.ownerEmail, 48);
            outBuffer.write(this.yearsNumber);
            outBuffer.write(this.reserved1);
            LMUtils.writeShortToBuffer(outBuffer, this.usersNumber);
            if (this.licenseFormat == LMLicenseFormat.ADVANCED) {
                outBuffer.write(0);
                outBuffer.write(0);
                outBuffer.write(this.roles.size());
                for (LMLicenseRole role : this.roles) {
                    LMUtils.writeStringToBuffer(outBuffer, role.getRole().name(), 16);
                    LMUtils.writeIntToBuffer(outBuffer, role.getUsersNumber());
                }
            }
        }
        if (this.isMultiInstance()) {
            outBuffer.write(0);
            outBuffer.write(0);
            LMUtils.writeShortToBuffer(outBuffer, this.serversNumber);
            LMUtils.writeIntToBuffer(outBuffer, this.getGroupUsers().size());
            for (LMGroupUser groupUser : this.getGroupUsers()) {
                outBuffer.write(0);
                LMUtils.writeStringToBuffer(outBuffer, groupUser.getEmail(), 128);
                LMUtils.writeStringToBuffer(outBuffer, groupUser.getUserName(), 128);
                if (this.licenseFormat != LMLicenseFormat.ADVANCED) continue;
                LMUtils.writeStringToBuffer(outBuffer, groupUser.getLicenseRole().name(), 16);
            }
        }
        return outBuffer.getBuffer();
    }

    public String getDataHash() {
        byte[] data = this.getData();
        return this.makeMD5Digest(data);
    }

    public String getUpdateRequestHash() {
        byte[] data = new byte[25];
        ByteBuffer buffer = ByteBuffer.wrap(data);
        LMUtils.putStringToBuffer(buffer, this.licenseId, 16);
        buffer.put(this.licenseType.getId());
        long timestampSeconds = (this.licenseIssueTime.getTime() + 999L) / 1000L * 1000L;
        LMUtils.putDateToBuffer(buffer, new Date(timestampSeconds));
        return "1:" + this.makeMD5Digest(data);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    private String makeMD5Digest(byte[] data) {
        try {
            md5hash = MessageDigest.getInstance("MD5").digest(data);
            return CommonUtils.toHexString((byte[])md5hash).toLowerCase(Locale.ENGLISH).trim();
        }
        catch (NoSuchAlgorithmException v0) {
            LMLicense.log.severe("No MD5 digest. Use simple sum.");
            sum = 0L;
            var7_4 = data;
            var6_5 = data.length;
            var5_6 = 0;
            ** while (var5_6 < var6_5)
        }
lbl-1000:
        // 1 sources

        {
            b = var7_4[var5_6];
            sum += (long)b;
            ++var5_6;
            continue;
        }
lbl15:
        // 1 sources

        return Long.toHexString(sum);
    }

    public String toString() {
        return "licenseId=" + this.licenseId + "\nlicenseType=" + (Object)((Object)this.licenseType) + "\nlicenseIssueTime=" + this.licenseIssueTime + "\nlicenseStartTime=" + this.licenseStartTime + "\nlicenseEndTime=" + this.licenseEndTime + "\nflags=" + this.flags + "\nproductId=" + this.productId + "\nproductVersion=" + this.productVersion + "\nownerId=" + this.ownerId + "\nownerCompany=" + this.ownerCompany + "\nownerName=" + this.ownerName + "\nownerEmail=" + this.ownerEmail + "\nyearsNumber=" + this.yearsNumber + "\nusersNumber=" + this.usersNumber;
    }

    public boolean isSubscription() {
        return (this.flags & 8L) == 8L;
    }

    public boolean isValidForProduct(LMProduct product) {
        return this.productId.equals(product.getId()) || ArrayUtils.contains((Object[])product.getUmbrellaProducts(), (Object)this.productId);
    }

    public boolean isValidFor(LMProduct product, LMProductRelease productRelease, boolean checkExpired) {
        Date licenseEndTime;
        if (!this.isValidForProduct(product)) {
            return false;
        }
        if (this.isSubscription()) {
            return true;
        }
        if (this.licenseType == LMLicenseType.TEAM && (licenseEndTime = new Date(this.licenseStartTime.getTime() + 86400000L * (long)(365 * this.yearsNumber + 14))).compareTo(new Date()) < 0) {
            return true;
        }
        if ((this.flags & 0x20L) == 32L && !CommonUtils.equalObjects((Object)this.getProductVersion(), (Object)product.getVersion())) {
            return false;
        }
        if (this.getLicenseType() == LMLicenseType.ULTIMATE) {
            return true;
        }
        if (checkExpired && this.isExpired()) {
            return false;
        }
        return !this.isOutOfSupport(product, productRelease);
    }

    public boolean isMultiInstance() {
        return CommonUtils.isBitSet((long)this.flags, (long)2048L);
    }

    public boolean isExpired() {
        Date curDate = new Date();
        Date licenseEndTime = this.getLicenseEndTime();
        switch (this.getLicenseType()) {
            case STANDARD: 
            case TRIAL: 
            case ACADEMIC: {
                if (licenseEndTime != null) break;
                licenseEndTime = new Date(this.licenseStartTime.getTime() + 31536000000L);
            }
        }
        return licenseEndTime != null && licenseEndTime.compareTo(curDate) < 0;
    }

    private boolean isOutOfSupport(LMProduct product, LMProductRelease productRelease) {
        if (this.getLicenseType() == LMLicenseType.TRIAL) {
            return this.isExpired();
        }
        Date releaseDate = productRelease == null ? product.getReleaseDate() : productRelease.getReleaseDate();
        Date licenseEndTime = this.getSupportEndDate();
        if (licenseEndTime.compareTo(releaseDate) < 0) {
            Date curDate = new Date();
            if (curDate.compareTo(releaseDate) < 0) {
                return this.isExpired();
            }
            return true;
        }
        return false;
    }

    public LMStatusDetails getLicenseStatus(LMProduct product) {
        if (!this.isValidForProduct(product)) {
            return new LMStatusDetails("Wrong product", "You can't use this license with product '" + product.getName() + "'", false);
        }
        if (this.isSubscription()) {
            if (this.remoteStatus != null) {
                return this.remoteStatus;
            }
            return new LMStatusDetails("Subscription", "Valid subscription", true);
        }
        if ((this.flags & 0x20L) == 32L && !CommonUtils.equalObjects((Object)this.getProductVersion(), (Object)product.getVersion())) {
            return new LMStatusDetails("Only version " + this.getProductVersion() + " supported", "Your license is limited to the version " + product.getName() + " " + this.getProductVersion() + " and can't be used with other produce versions", false);
        }
        if (this.getLicenseType() == LMLicenseType.ULTIMATE) {
            return new LMStatusDetails("Ultimate license", "Ultimate license", true);
        }
        if (this.isExpired()) {
            return new LMStatusDetails("Expired (" + LMUtils.HR_DATE_FORMAT.format(this.getExpireDate()) + ")", "Your license has been expired at " + LMUtils.HR_DATE_FORMAT.format(this.getExpireDate()), false);
        }
        if (this.isOutOfSupport(product, null)) {
            return new LMStatusDetails("Not valid for " + product.getVersion(), "Your license is not valid for " + product.getName() + " " + product.getVersion() + ".\n" + "Product release date (" + LMUtils.HR_DATE_FORMAT.format(product.getReleaseDate()) + ") is later than the license end-of-support date (" + LMUtils.HR_DATE_FORMAT.format(this.getSupportEndDate()) + ").\n" + "You can use earlier versions or upgrade your license.", false);
        }
        if (!this.isValidFor(product, null, false)) {
            return new LMStatusDetails("Invalid license", "Thos license is not applicable", false);
        }
        return new LMStatusDetails("Valid", "Valid license", true);
    }

    public Date getExpireDate() {
        Date licenseEndTime = this.getLicenseEndTime();
        switch (this.getLicenseType()) {
            case STANDARD: 
            case TRIAL: 
            case ACADEMIC: {
                if (licenseEndTime != null) break;
                licenseEndTime = new Date(this.licenseStartTime.getTime() + 31536000000L);
            }
        }
        return licenseEndTime;
    }

    @NotNull
    public Date getSupportEndDate() {
        if (this.licenseEndTime != null) {
            return this.licenseEndTime;
        }
        Calendar cl = Calendar.getInstance();
        if (this.licenseStartTime != null) {
            cl.setTime(this.licenseStartTime);
        } else {
            cl.setTime(this.licenseIssueTime);
        }
        byte yearsNumber = this.getYearsNumber();
        if (yearsNumber <= 0) {
            yearsNumber = 1;
        }
        cl.add(1, yearsNumber);
        return cl.getTime();
    }

    public String getLicenseTypeFull() {
        if (this.isSubscription()) {
            return "Subscription";
        }
        return this.licenseType.getDisplayName();
    }

    public LMStatusDetails getRemoteStatus() {
        return this.remoteStatus;
    }

    public void setRemoteStatus(LMStatusDetails remoteStatus) {
        this.remoteStatus = remoteStatus;
    }
}

