/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jkiss.lm.LMException;
import org.jkiss.utils.Base64;

public class LMEncryption {
    private static final String ASYNC_TRANSFORMATION_PADDING = "RSA/ECB/PKCS1Padding";
    private static final String SYNC_ALGORITHM = "md5";
    private static final String SYNC_SECRET_KEY_ALGORITHM = "DESede";
    private static final String SYNC_TRANSFORMATION_PADDING = "DESede/CBC/PKCS5Padding";
    private static final String ALGORITHM = "RSA";
    private static final int RSA_CHUNK_MAX_SIZE = 245;
    private static final int RSA_BLOCK_SIZE = 256;

    public static PublicKey generatePublicKey(byte[] publicKeyBytes) throws LMException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
            return keyFactory.generatePublic(publicKeySpec);
        }
        catch (Exception e) {
            throw new LMException(e);
        }
    }

    public static PrivateKey generatePrivateKey(byte[] privateKeyBytes) throws LMException {
        PrivateKey privateKey = null;
        if (privateKeyBytes != null) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
                PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
                privateKey = keyFactory.generatePrivate(privateKeySpec);
            }
            catch (Exception e) {
                throw new LMException(e);
            }
        }
        return privateKey;
    }

    public static PrivateKey generatePrivateKey(String encodedPrivateKey) throws LMException {
        byte[] privateKeyBytes = Base64.decode((String)encodedPrivateKey);
        return LMEncryption.generatePrivateKey(privateKeyBytes);
    }

    public static byte[] decrypt(byte[] data, Key key) throws LMException {
        return LMEncryption.cipherAsymmetric(data, key, 2);
    }

    private static byte[] cipherAsymmetric(byte[] data, Key key, int mode) throws LMException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int chunkSize = mode == 2 ? 256 : 245;
        int chunkCount = data.length / chunkSize;
        if (data.length % chunkSize > 0) {
            ++chunkCount;
        }
        try {
            Cipher cipher = Cipher.getInstance(ASYNC_TRANSFORMATION_PADDING);
            int i = 0;
            while (i < chunkCount) {
                cipher.init(mode, key);
                int offset = i * chunkSize;
                int length = chunkSize;
                if (offset + length > data.length) {
                    length = data.length - chunkSize * i;
                }
                byte[] segment = Arrays.copyOfRange(data, offset, offset + length);
                byte[] segmentEncrypted = cipher.doFinal(segment);
                buffer.write(segmentEncrypted);
                ++i;
            }
            return buffer.toByteArray();
        }
        catch (Exception e) {
            throw new LMException(e);
        }
    }

    public static byte[] decrypt(byte[] data, String digestString) throws LMException {
        return LMEncryption.cipherSymmetric(data, digestString, 2);
    }

    private static byte[] cipherSymmetric(byte[] data, String digestString, int mode) throws LMException {
        try {
            MessageDigest md = MessageDigest.getInstance(SYNC_ALGORITHM);
            byte[] digestOfPassword = md.digest(digestString.getBytes("utf-8"));
            byte[] keyBytes = Arrays.copyOf(digestOfPassword, 24);
            int j = 0;
            int k = 16;
            while (j < 8) {
                keyBytes[k++] = keyBytes[j++];
            }
            SecretKeySpec key = new SecretKeySpec(keyBytes, SYNC_SECRET_KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(SYNC_TRANSFORMATION_PADDING);
            cipher.init(mode, (Key)key, new IvParameterSpec(new byte[8]));
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new LMException(e);
        }
    }

    public static byte[] encrypt(byte[] data, Key key) throws LMException {
        return LMEncryption.cipherAsymmetric(data, key, 1);
    }

    public static byte[] encrypt(byte[] data, String digestString) throws LMException {
        return LMEncryption.cipherSymmetric(data, digestString, 1);
    }

    public static KeyPair generateKeyPair() throws LMException {
        return LMEncryption.generateKeyPair(1024);
    }

    public static KeyPair generateKeyPair(int keySize) throws LMException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            keyGen.initialize(keySize, random);
            return keyGen.generateKeyPair();
        }
        catch (Exception e) {
            throw new LMException(e);
        }
    }

    private KeyPair generateKeyPair(byte[] publicKeyBytes, byte[] privateKeyBytes) throws LMException {
        PublicKey publicKey = LMEncryption.generatePublicKey(publicKeyBytes);
        PrivateKey privateKey = LMEncryption.generatePrivateKey(privateKeyBytes);
        return new KeyPair(publicKey, privateKey);
    }
}

