/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.edit;

import com.dbeaver.db.sqlite.model.SQLiteAttachedDatabase;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class SQLiteAttachedDatabaseManager
extends SQLObjectEditor<SQLiteAttachedDatabase, SQLiteDataSource> {
    private static final String SQL_ATTACH_DATABASE = "ATTACH DATABASE %s AS %s";
    private static final String SQL_DETACH_DATABASE = "DETACH DATABASE %s";

    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLiteAttachedDatabase> getObjectsCache(SQLiteAttachedDatabase object) {
        return null;
    }

    protected SQLiteAttachedDatabase createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        return new SQLiteAttachedDatabase((GenericDataSource)container, null, "TMP", -1, "");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        SQLiteAttachedDatabase object = (SQLiteAttachedDatabase)command.getObject();
        SQLDatabasePersistAction attachDatabase = new SQLDatabasePersistAction("Attach Database", String.format(SQL_ATTACH_DATABASE, DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)((SQLiteAttachedDatabase)command.getObject()).getFile()), DBUtils.getQuotedIdentifier((DBPDataSource)object.getDataSource(), (String)((SQLiteAttachedDatabase)command.getObject()).getName())));
        actions.add((DBEPersistAction)attachDatabase);
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        if (((SQLiteAttachedDatabase)command.getObject()).getName().equals("main") || ((SQLiteAttachedDatabase)command.getObject()).getName().equals("temp")) {
            return;
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Detach Database", String.format(SQL_DETACH_DATABASE, DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)command.getObject())))));
    }

    public boolean canDeleteObject(SQLiteAttachedDatabase object) {
        return super.canDeleteObject((DBSObject)object) && !"temp".equals(object.getName()) && !"main".equals(object.getName());
    }

    public boolean canEditObject(SQLiteAttachedDatabase object) {
        return false;
    }
}

