/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite;

import com.dbeaver.db.sqlite.SQLiteDataSourceExt;
import com.dbeaver.db.sqlite.SQLiteMetaModelExt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataSourceProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProviderSynchronizable;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.net.DBWTunnel;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementation;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLiteDataSourceProviderExt
extends SQLiteDataSourceProvider
implements DBPDataSourceProviderSynchronizable {
    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new SQLiteDataSourceExt(monitor, container, (GenericMetaModel)new SQLiteMetaModelExt());
    }

    public void syncLocalDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        try {
            SSHImplementation tunnel = SQLiteDataSourceProviderExt.getTunnel(container);
            DBPConnectionConfiguration configuration = container.getConnectionConfiguration();
            DBPConnectionConfiguration actualConfiguration = container.getActualConnectionConfiguration();
            Path localFilePath = DBWorkbench.getPlatform().getTempFolder(monitor, "sqlite-remote-database").resolve(String.valueOf(container.getId()) + ".db");
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(localFilePath, new OpenOption[0]));){
                    monitor.beginTask("Download remote database file", 1);
                    tunnel.getFile(configuration.getDatabaseName(), (OutputStream)os, monitor);
                    monitor.worked(1);
                    actualConfiguration.setDatabaseName(localFilePath.toAbsolutePath().toString());
                    actualConfiguration.setProperty("sqlite-remote-database-file", configuration.getDatabaseName());
                    actualConfiguration.setProperty("sqlite-remote-database-counter", String.valueOf(SQLiteDataSourceProviderExt.getChangeCounter(localFilePath)));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                monitor.done();
            }
        }
        catch (IOException e) {
            throw new DBException("Error retrieving remote database file", (Throwable)e);
        }
    }

    public void syncRemoteDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        SSHImplementation tunnel = SQLiteDataSourceProviderExt.getTunnel(container);
        DBPConnectionConfiguration configuration = container.getActualConnectionConfiguration();
        Path localFilePath = Path.of(configuration.getDatabaseName(), new String[0]);
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(localFilePath, new OpenOption[0]));){
                    monitor.beginTask("Upload local database file", 1);
                    tunnel.putFile((InputStream)is, configuration.getProperty("sqlite-remote-database-file"), monitor);
                    monitor.worked(1);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new DBException("Error uploading local database file", (Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
        configuration.setProperty("sqlite-remote-database-counter", String.valueOf(SQLiteDataSourceProviderExt.getChangeCounter(localFilePath)));
    }

    public boolean isLocalDataSourceSynchronized(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        int actualFileCounter;
        DBPConnectionConfiguration configuration = container.getActualConnectionConfiguration();
        Path localFilePath = Path.of(configuration.getDatabaseName(), new String[0]);
        try {
            monitor.beginTask("Read local database file", 1);
            actualFileCounter = SQLiteDataSourceProviderExt.getChangeCounter(localFilePath);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return actualFileCounter == Integer.parseInt(configuration.getProperty("sqlite-remote-database-counter"));
    }

    public boolean isRemoteDataSourceSynchronized(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        ByteArrayOutputStream buffer;
        DBPConnectionConfiguration configuration;
        block15: {
            SSHImplementation tunnel = SQLiteDataSourceProviderExt.getTunnel(container);
            configuration = container.getActualConnectionConfiguration();
            buffer = new ByteArrayOutputStream(28);
            try {
                try {
                    Throwable throwable = null;
                    Object var7_10 = null;
                    try (LimitOutputStream os = new LimitOutputStream(buffer, 28);){
                        monitor.beginTask("Download remote database file", 1);
                        tunnel.getFile(configuration.getProperty("sqlite-remote-database-file"), (OutputStream)os, monitor);
                        monitor.worked(1);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (!(GeneralUtils.getRootCause((Throwable)e) instanceof LimitReachedException)) {
                        throw new DBException("Error retrieving remote database file", (Throwable)e);
                    }
                    monitor.done();
                    break block15;
                }
            }
            catch (Throwable throwable) {
                monitor.done();
                throw throwable;
            }
            monitor.done();
        }
        int actualFileCounter = ByteBuffer.wrap(buffer.toByteArray()).position(24).getInt();
        int cachedFileCounter = Integer.parseInt(configuration.getProperty("sqlite-remote-database-counter"));
        return actualFileCounter == cachedFileCounter;
    }

    public boolean isSynchronizationEnabled(@NotNull DBPDataSourceContainer container) {
        return this.isPropertyEnabled(container, "sqlite-remote-enabled") && SQLiteDataSourceProviderExt.findTunnel(container) != null;
    }

    private boolean isPropertyEnabled(@NotNull DBPDataSourceContainer container, String property) {
        return CommonUtils.toBoolean((Object)container.getConnectionConfiguration().getProperty(property)) || CommonUtils.toBoolean((Object)container.getConnectionConfiguration().getProviderProperty(property));
    }

    @NotNull
    private static SSHImplementation getTunnel(@NotNull DBPDataSourceContainer container) throws DBException {
        SSHImplementation tunnel = SQLiteDataSourceProviderExt.findTunnel(container);
        if (tunnel == null) {
            throw new DBException("SSH tunnel is not configured");
        }
        return tunnel;
    }

    @Nullable
    private static SSHImplementation findTunnel(@NotNull DBPDataSourceContainer container) {
        DBWNetworkHandler[] dBWNetworkHandlerArray = container.getActiveNetworkHandlers();
        int n = dBWNetworkHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBWTunnel tunnel;
            Object implementation;
            DBWNetworkHandler handler = dBWNetworkHandlerArray[n2];
            if (handler instanceof DBWTunnel && (implementation = (tunnel = (DBWTunnel)handler).getImplementation()) instanceof SSHImplementation) {
                return (SSHImplementation)implementation;
            }
            ++n2;
        }
        return null;
    }

    private static int getChangeCounter(@NotNull Path path) throws DBException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.READ);){
                channel.position(24L);
                channel.read(buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading database file", (Throwable)e);
        }
        return buffer.position(0).getInt();
    }

    private static class LimitOutputStream
    extends FilterOutputStream {
        private final int limit;
        private int count;

        public LimitOutputStream(@NotNull OutputStream out, int limit) {
            super(out);
            this.limit = limit;
            this.count = 0;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count < this.limit) {
                this.out.write(b);
                ++this.count;
            } else {
                throw new LimitReachedException();
            }
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            if (this.count < this.limit) {
                int min = Math.min(this.limit - this.count, len);
                this.out.write(b, off, min);
                this.count += min;
            } else {
                throw new LimitReachedException();
            }
        }
    }

    private static class LimitReachedException
    extends IOException {
        private LimitReachedException() {
        }
    }
}

