/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.MGConstants;
import com.dbeaver.model.NoSQLDialect;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.sql.RelationalSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLExpressionFormatter;

public class MGSQLDialect
extends NoSQLDialect
implements RelationalSQLDialect {
    public static final MGSQLDialect INSTANCE = new MGSQLDialect();

    public MGSQLDialect() {
        this.addKeywords(Arrays.asList(MGConstants.JS_KEYWORDS), DBPKeywordType.KEYWORD);
        this.addFunctions(Arrays.asList(MGConstants.SQL_FUNCTIONS));
        this.addDataTypes(List.of(MGConstants.JS_TYPES));
    }

    @NotNull
    public String getDialectId() {
        return "mongodb";
    }

    @NotNull
    public String getDialectName() {
        return "Mongo";
    }

    public String[][] getIdentifierQuoteStrings() {
        return new String[][]{{"\"", "\""}};
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public String addFiltersToQuery(DBRProgressMonitor monitor, DBPDataSource dataSource, String query, DBDDataFilter filter) {
        return this.getQueryGenerator().getQueryWithAppliedFilters(monitor, dataSource, query, filter);
    }

    public boolean isStandardSQL() {
        return false;
    }

    public boolean supportsOrderBy() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean isAmbiguousCountBroken() {
        return false;
    }

    @Nullable
    public SQLExpressionFormatter getCaseInsensitiveExpressionFormatter(@NotNull DBCLogicalOperator operator) {
        if (operator == DBCLogicalOperator.LIKE) {
            return (left, right) -> String.valueOf(left) + " ILIKE " + right;
        }
        return super.getCaseInsensitiveExpressionFormatter(operator);
    }
}

