/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.exec.MGCursor;
import com.dbeaver.db.mongodb.exec.MGResultSet;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.model.document.exec.DocumentReadStatement;
import com.mongodb.DBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public abstract class MGBaseStatement
extends DocumentReadStatement<MGSession> {
    private final String query;
    protected MGCollection collection;
    protected MGCursor result;
    protected MongoIterable iterableResult;
    protected List<Document> resultList;
    protected long updateRowCount = -1L;
    private Throwable executeError;
    protected long offset;
    protected long limit;
    private int fetchSize;

    protected MGBaseStatement(MGSession session, String query) {
        super((DBCSession)session);
        this.query = query;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public String getQueryString() {
        return this.query;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public MGResultSet openResultSet() throws DBCException {
        if (this.resultList != null) {
            return new MGResultSet(this, this.resultList);
        }
        if (this.result != null) {
            return new MGResultSet(this, this.result);
        }
        if (this.iterableResult != null) {
            return new MGResultSet(this, this.iterableResult.cursor());
        }
        return null;
    }

    public boolean hasResultSet() {
        return this.resultList != null || this.result != null || this.iterableResult != null;
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public long getUpdateRowCount() {
        return this.updateRowCount;
    }

    public boolean nextResults() throws DBCException {
        this.updateRowCount = -1L;
        this.result = null;
        this.iterableResult = null;
        this.resultList = null;
        return false;
    }

    public void close() {
        this.result = null;
        this.iterableResult = null;
        this.resultList = null;
        if (((MGSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public int getResultsFetchSize() {
        return this.fetchSize;
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
        this.fetchSize = fetchSize;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("Mongo query cancel not implemented");
        }
        blockThread.interrupt();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)((MGSession)this.getSession()).getExecutionContext());
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (((MGSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (((MGSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), this.executeError);
        }
    }

    protected void startBlock() {
        ((MGSession)this.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, null);
    }

    protected void endBlock() {
        ((MGSession)this.getSession()).getProgressMonitor().endBlock();
    }

    protected void setExecutionResult(Document commandResult) {
        Object retval = commandResult.get((Object)"retval");
        if (retval instanceof FindIterable) {
            this.result = new MGCursor((FindIterable<Document>)((FindIterable)retval));
        } else if (retval instanceof MGCursor) {
            this.result = (MGCursor)retval;
        } else if (retval instanceof MongoIterable) {
            this.iterableResult = (MongoIterable)retval;
        } else {
            this.resultList = new ArrayList<Document>(1);
            if (retval == null) {
                this.resultList.add(commandResult);
            } else if (retval instanceof Collection) {
                boolean objects = true;
                for (Object obj : (Collection)retval) {
                    if (obj instanceof DBObject) continue;
                    objects = false;
                    break;
                }
                if (objects) {
                    this.resultList.addAll((Collection)retval);
                } else {
                    this.resultList.add((Document)retval);
                }
            } else if (retval instanceof Document) {
                this.resultList.add((Document)retval);
            } else {
                this.resultList.add(new Document("retval", retval));
            }
        }
    }

    protected void setExecutionResult(Object retval) {
        if (retval instanceof FindIterable) {
            this.result = new MGCursor((FindIterable<Document>)((FindIterable)retval));
        } else if (retval instanceof MGCursor) {
            this.result = (MGCursor)retval;
        } else if (retval instanceof MongoIterable) {
            this.iterableResult = (MongoIterable)retval;
        } else {
            this.resultList = new ArrayList<Document>(1);
            if (retval instanceof Collection) {
                boolean objects = true;
                for (Object obj : (Collection)retval) {
                    if (obj instanceof DBObject) continue;
                    objects = false;
                    break;
                }
                if (objects) {
                    this.resultList.addAll((Collection)retval);
                } else {
                    this.resultList.add((Document)retval);
                }
            } else if (retval instanceof Document) {
                this.resultList.add((Document)retval);
            } else {
                this.resultList.add(new Document("result", retval));
            }
        }
    }

    protected void setExecutionResult(UpdateResult updateResult) {
        this.updateRowCount = updateResult.getModifiedCount();
    }

    protected void setExecutionResult(DeleteResult deleteResult) {
        this.updateRowCount = deleteResult.getDeletedCount();
    }

    protected void setExecutionResult(InsertOneResult insertOneResult) {
        this.updateRowCount = 1L;
    }

    public DBSEntity getSourceEntity() {
        return this.collection;
    }
}

