/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;

public abstract class SConnectionHandle
implements Connection {
    protected boolean m_isClosed = true;
    protected SConnection m_connection;
    protected SPooledConnection m_pooledConnection;

    protected SConnectionHandle(SConnection connection, SPooledConnection pooledConnection) throws SQLException {
        this.m_connection = connection;
        this.m_pooledConnection = pooledConnection;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.clearWarnings();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        this.m_isClosed = true;
        this.m_connection.closeChildObjects();
        this.m_pooledConnection.onHandleClose();
    }

    @Override
    public void commit() throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.commit();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.createStatement();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.createStatement(resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getAutoCommit();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getCatalog();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getHoldability();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    protected ILogger getLogger() {
        return this.m_connection.m_logger;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getMetaData();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getTransactionIsolation();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getTypeMap();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.getWarnings();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    protected IWarningListener getWarningListener() {
        return this.m_connection.m_warningListener;
    }

    @Override
    public boolean isClosed() {
        return this.m_isClosed || this.m_connection.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.isReadOnly();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.nativeSQL(sql);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareCall(sql);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(sql, columnIndexes);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.prepareStatement(sql, columnNames);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.rollback();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.rollback(savepoint);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setCatalog(catalog);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setHoldability(holdability);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.setSavepoint();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkIfOpen();
        try {
            return this.m_connection.setSavepoint(name);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkIfOpen();
        try {
            this.m_connection.setTypeMap(map);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), typeName, elements);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public Blob createBlob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public Clob createClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public NClob createNClob() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), typeName, attributes);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed() && this.m_connection.getDSIConnection().isAlive();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    void open() throws SQLException {
        if (!this.m_isClosed) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_OPEN, this.m_connection.getWarningListener(), ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
        this.m_isClosed = false;
    }

    void forceClose() throws SQLException {
        this.m_connection.close();
    }

    protected void checkIfOpen() throws SQLException {
        if (this.m_isClosed) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
    }
}

