/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.deserializer.impl;

import com.vertica.core.VConnection;
import com.vertica.deserializer.MultiFormatDeserializer;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.util.ClientErrorException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.util.Calendar;
import java.util.HashMap;
import java.util.SimpleTimeZone;

public class TimeDeserializerImpl
implements MultiFormatDeserializer {
    private int m_oid;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long MILLIS_PER_MIN = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private static final int ASCII_OFFSET = 48;

    public TimeDeserializerImpl(int n) {
        this.m_oid = n;
    }

    @Override
    public boolean deserializeBinary(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        long l3 = ByteBuffer.wrap(byArray).getLong();
        if (this.m_oid == 11) {
            long l4 = Math.round((double)l3 / 1000.0);
            long l5 = Calendar.getInstance().getTimeZone().getOffset(0L);
            dataWrapper.setTime(new Time(l4 -= l5));
        } else if (this.m_oid == 15) {
            int n = (int)(86400L - (l3 & 0xFFFFFFL)) * 1000;
            long l6 = Math.round((double)(l3 >> 24) / 1000.0);
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n, "");
            TimeTz timeTz = new TimeTz(new Time(l6), Calendar.getInstance(simpleTimeZone));
            dataWrapper.setTime(timeTz);
        } else {
            throw new ClientErrorException("Invalid time/timetz type " + this.m_oid);
        }
        return false;
    }

    @Override
    public boolean deserializeText(long l, long l2, DataWrapper dataWrapper, byte[] byArray, HashMap<String, Object> hashMap) throws UnsupportedEncodingException, ClientErrorException {
        int n;
        int[] nArray = new int[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (n = 0; n < byArray.length; ++n) {
            if (byArray[n] == 58 || byArray[n] == 32) {
                ++n2;
                continue;
            }
            if (byArray[n] == 46) {
                ++n2;
                n3 = n + 1;
                continue;
            }
            if (byArray[n] == 43 || byArray[n] == 45) {
                n4 = n;
                bl = true;
                break;
            }
            nArray[n2] = byArray[n] - 48 + nArray[n2] * 10;
        }
        if (n4 == 0) {
            n4 = byArray.length;
        }
        long l3 = (long)nArray[0] * 3600000L + (long)nArray[1] * 60000L + (long)(nArray[2] * 1000);
        for (int i = n4 - n3; i < 9; ++i) {
            nArray[3] = nArray[3] * 10;
        }
        l3 += (long)((nArray[3] + 500000) / 1000000);
        Calendar calendar = null;
        if (bl) {
            if (this.m_oid != 15) {
                throw new ClientErrorException("Invalid timetz type " + this.m_oid);
            }
            int n5 = n;
            int n6 = TimeDeserializerImpl.getTimeZoneOffSet(byArray, n5);
            calendar = Calendar.getInstance(new SimpleTimeZone(n6, new String(byArray, n5, byArray.length - n5, VConnection.VERTICA_CHARSET)));
            TimeTz timeTz = new TimeTz(new Time(l3 -= (long)n6), calendar);
            dataWrapper.setTime(timeTz);
        } else {
            long l4 = Calendar.getInstance().getTimeZone().getOffset(0L);
            l3 -= l4;
            if (this.m_oid != 11) {
                throw new ClientErrorException("Invalid time type " + this.m_oid);
            }
            Time time = new Time(l3);
            dataWrapper.setTime(time);
        }
        return false;
    }

    public static int getTimeZoneOffSet(byte[] byArray, int n) {
        int n2 = byArray[n] == 45 ? -1 : 1;
        ++n;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[3];
        while (n < byArray.length) {
            if (byArray[n] == 58) {
                ++n3;
            } else {
                if (byArray[n] == 32) break;
                nArray[n3] = byArray[n] - 48 + nArray[n3] * 10;
            }
            ++n;
        }
        n4 = nArray[0] * 60 * 60 * 1000 + nArray[1] * 60 * 1000 + nArray[2] * 1000;
        return n4 *= n2;
    }
}

