/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.sql.vqb.model;

import com.dbeaver.model.sql.vqb.model.VQBJoinType;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDContext;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class ERDJoin
extends ERDAssociation {
    public ERDJoin(ERDEntity sourceEntity, ERDEntity targetEntity, boolean reflect) {
        super((ERDElement)sourceEntity, (ERDElement)targetEntity, reflect);
    }

    public List<Expression> makeExpressionFromConditions() {
        List source = this.getSourceAttributes();
        List target = this.getTargetAttributes();
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        Expression expr = this.makeEquals((ERDEntityAttribute)source.get(0), (ERDEntityAttribute)target.get(0));
        if (source.size() == 1) {
            return List.of(expr);
        }
        return List.of(this.makeAndExpression(source, target, 1, expr));
    }

    public ERDEntity getSourceEntity() {
        return (ERDEntity)super.getSourceEntity();
    }

    public ERDEntity getTargetEntity() {
        return (ERDEntity)super.getTargetEntity();
    }

    private Expression makeAndExpression(List<ERDEntityAttribute> source, List<ERDEntityAttribute> target, int index, Expression expr) {
        if (index < source.size() - 1) {
            return new AndExpression(this.makeAndExpression(source, target, index + 1, this.makeEquals(source.get(index), target.get(index))), expr);
        }
        return new AndExpression(expr, this.makeEquals(source.get(index), target.get(index)));
    }

    private Expression makeEquals(ERDEntityAttribute src, ERDEntityAttribute target) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression(this.makeColumn(this.getSourceEntity(), src));
        equalsTo.setRightExpression(this.makeColumn(this.getTargetEntity(), target));
        return equalsTo;
    }

    private Expression makeColumn(ERDEntity srcEntity, ERDEntityAttribute src) {
        return new Column(VQBUtils.getTableFromEntity(srcEntity), DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)src.getObject())));
    }

    public void makeConditionsFromReferrer(DBSEntityReferrer association, ERDEntity sourceEntity, ERDEntity targetEntity) {
        this.resolveAttributes(association, sourceEntity, targetEntity);
    }

    public Join createStatementJoin() {
        Join join = new Join();
        join.setInner(true);
        join.setRightItem((FromItem)this.getTargetEntity().getUserData());
        join.setOnExpressions(this.makeExpressionFromConditions());
        this.setUserData(join);
        return join;
    }

    public void updateStatementJoin(Join join) {
        join.setOnExpressions(this.makeExpressionFromConditions());
        this.setUserData(join);
    }

    public Map<String, Object> toMap(@NotNull ERDContext context, boolean fullInfo) {
        Map map = super.toMap(context, fullInfo);
        Join join = (Join)this.getUserData();
        if (join == null) {
            join = this.createStatementJoin();
        }
        map.put("joinType", VQBJoinType.getByJoin(join));
        return map;
    }
}

