/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.model.meta.Property;

public class PostgreDefaultPrivilege
extends PostgreObjectPrivilege {
    private PostgrePrivilegeGrant.Kind underKind;

    public PostgreDefaultPrivilege(PostgrePrivilegeOwner owner, String grantee, List<PostgrePrivilegeGrant> privileges) {
        super(owner, grantee, privileges);
    }

    @Nullable
    public PostgrePrivilegeGrant.Kind getUnderKind() {
        return this.underKind;
    }

    public void setUnderKind(PostgrePrivilegeGrant.Kind underKind) {
        this.underKind = underKind;
    }

    void setUnderKind(@NotNull String kind) {
        if (PostgreClass.RelKind.r.getCode().equals(kind)) {
            this.underKind = PostgrePrivilegeGrant.Kind.TABLE;
        } else if (PostgreClass.RelKind.S.getCode().equals(kind)) {
            this.underKind = PostgrePrivilegeGrant.Kind.SEQUENCE;
        } else if ("f".equals(kind)) {
            this.underKind = PostgrePrivilegeGrant.Kind.FUNCTION;
        } else if ("T".equals(kind)) {
            this.underKind = PostgrePrivilegeGrant.Kind.TYPE;
        }
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.getOwner() == null ? "" : String.valueOf(this.getOwner().getName()) + "." + (Object)((Object)this.underKind);
    }
}

