/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class CustomClassLoader
extends URLClassLoader {
    private static final String FILE_PROTOCOL = "file://localhost/";
    private static final String JAR_PROTOCOL = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0 ? "jar:file:/" : "jar:file:";
    private static final String JAR_END = "!/";

    public CustomClassLoader(String string) throws MalformedURLException {
        super(CustomClassLoader.getURLArray(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(string);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                try {
                    clazz = this.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = this.getParentClassLoader().loadClass(string);
                }
            }
            return clazz;
        }
    }

    @Override
    public URL getResource(String string) {
        URL uRL = this.findResource(string);
        if (null == uRL) {
            uRL = this.getParentClassLoader().getResource(string);
        }
        return uRL;
    }

    private ClassLoader getParentClassLoader() {
        ClassLoader classLoader = this.getParent();
        if (classLoader == null) {
            classLoader = CustomClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private static URL[] getURLArray(String string) throws MalformedURLException {
        String[] stringArray = string.split(";");
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            File file = new File(stringArray[i]);
            if (!file.exists()) {
                throw new RuntimeException(String.format("\"%s\" doesn't exist!", stringArray[i]));
            }
            if (file.isDirectory()) {
                string2 = FILE_PROTOCOL + stringArray[i] + (stringArray[i].endsWith("/") ? "" : "/");
            } else {
                if (!file.isFile()) {
                    throw new RuntimeException(String.format("\"%s\" is not a file or directory!", stringArray[i]));
                }
                string2 = JAR_PROTOCOL + stringArray[i] + JAR_END;
            }
            try {
                uRLArray[i] = new URL(string2);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new MalformedURLException("Malformed URL: " + stringArray[i] + "\n" + malformedURLException.getLocalizedMessage());
            }
        }
        return uRLArray;
    }
}

