/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.jdbc41;

import com.simba.athena.dsi.dataengine.interfaces.IResultSet;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceID;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.jdbc.common.SMetaDataProxy;
import com.simba.athena.jdbc.jdbc41.S41ResultSetMetaData;
import com.simba.athena.jdbc.jdbc41.utilities.ResultSetUtilities;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.utilities.JDBCVersion;
import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S41MetaDataProxy
extends SMetaDataProxy {
    protected S41MetaDataProxy(DatabaseMetaData databaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger) throws SQLException {
        super(databaseMetaData, iResultSet, metadataSourceID, iLogger, JDBCVersion.JDBC41);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (null == this.m_resultMetaData) {
            this.generateMetadataList();
            this.m_resultMetaData = new S41ResultSetMetaData(this.m_resultSetColumns, this.m_logger, this.m_warningListener);
        }
        return this.m_resultMetaData;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clazz);
            this.checkIfOpen();
            return ResultSetUtilities.getObjectByType(this, n, clazz);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clazz);
        return this.getObject(this.findColumn(string), clazz);
    }
}

