/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.common.utilities.future;

import com.simba.athena.dsi.core.utilities.ClientInfoData;
import com.simba.athena.dsi.core.utilities.impl.future.ConversionConfig;
import com.simba.athena.dsi.core.utilities.impl.future.SignedIntJDBCDataSource;
import com.simba.athena.dsi.core.utilities.impl.future.StringJDBCDataSource;
import com.simba.athena.dsi.dataengine.impl.future.DSISimpleResultSet;
import com.simba.athena.dsi.dataengine.interfaces.IColumn;
import com.simba.athena.dsi.dataengine.interfaces.future.IJDBCDataSource;
import com.simba.athena.dsi.dataengine.interfaces.future.ISqlDataSource;
import com.simba.athena.dsi.dataengine.interfaces.future.ISqlDataSourceVector;
import com.simba.athena.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.utilities.MetaDataFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientInfoPropertiesMetadataSource
extends DSISimpleResultSet
implements ISqlDataSourceVector {
    private List<ClientInfoPropertyColumnInfo> m_columnData;
    private final List<ColumnMetadata> m_columns;
    private final int m_numRows;
    private final IJDBCDataSource[] m_dataSources = new IJDBCDataSource[4];

    public ClientInfoPropertiesMetadataSource(Map<String, ClientInfoData> map, IWarningListener iWarningListener) {
        this.m_numRows = this.initializeData(map);
        this.m_columns = MetaDataFactory.createClientInfoPropertiesMetadata();
        ConversionConfig conversionConfig = ConversionConfig.createFromDSIDriverSingleton();
        this.m_dataSources[0] = new StringJDBCDataSource(iWarningListener, conversionConfig){

            @Override
            public String get() throws ErrorException {
                return this.returnObject(ClientInfoPropertiesMetadataSource.this.getCurrentRowData().m_name);
            }
        };
        this.m_dataSources[1] = new SignedIntJDBCDataSource(iWarningListener, conversionConfig){

            @Override
            public int getInt() throws ErrorException, SQLException {
                this.setWasNull(false);
                return ClientInfoPropertiesMetadataSource.this.getCurrentRowData().m_maxLength;
            }
        };
        this.m_dataSources[2] = new StringJDBCDataSource(iWarningListener, conversionConfig){

            @Override
            public String get() throws ErrorException {
                return this.returnObject(ClientInfoPropertiesMetadataSource.this.getCurrentRowData().m_defaultValue);
            }
        };
        this.m_dataSources[3] = new StringJDBCDataSource(iWarningListener, conversionConfig){

            @Override
            public String get() throws ErrorException {
                return this.returnObject(ClientInfoPropertiesMetadataSource.this.getCurrentRowData().m_description);
            }
        };
    }

    protected final ClientInfoPropertyColumnInfo getCurrentRowData() {
        return this.m_columnData.get(this.getCurrentRow());
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_numRows;
    }

    @Override
    public List<? extends IColumn> getSelectColumns() throws ErrorException {
        return this.m_columns;
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        return this.getCurrentRow() + 1 < this.m_numRows;
    }

    @Override
    public boolean hasRowCount() {
        return true;
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        this.m_columnData = null;
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        return this.getCurrentRow() < this.m_numRows;
    }

    private int initializeData(Map<String, ClientInfoData> map) {
        this.m_columnData = new ArrayList<ClientInfoPropertyColumnInfo>();
        Set<String> set = map.keySet();
        Object[] objectArray = set.toArray(new String[set.size()]);
        Arrays.sort(objectArray, 0, objectArray.length);
        ClientInfoPropertyColumnInfo clientInfoPropertyColumnInfo = null;
        ClientInfoData clientInfoData = null;
        for (Object object : objectArray) {
            clientInfoData = map.get(object);
            clientInfoPropertyColumnInfo = new ClientInfoPropertyColumnInfo();
            clientInfoPropertyColumnInfo.m_name = clientInfoData.getName();
            clientInfoPropertyColumnInfo.m_defaultValue = clientInfoData.getDefaultValue();
            clientInfoPropertyColumnInfo.m_maxLength = clientInfoData.getMaxLength();
            clientInfoPropertyColumnInfo.m_description = clientInfoData.getDescription();
            this.m_columnData.add(clientInfoPropertyColumnInfo);
        }
        return objectArray.length;
    }

    @Override
    public ISqlDataSource getSqlDataSource(int n) throws ErrorException {
        return this.m_dataSources[n];
    }

    private static class ClientInfoPropertyColumnInfo {
        public String m_name;
        public int m_maxLength;
        public String m_defaultValue;
        public String m_description;

        private ClientInfoPropertyColumnInfo() {
        }
    }
}

