/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.common.future;

import com.simba.athena.dsi.dataengine.interfaces.IColumn;
import com.simba.athena.dsi.dataengine.interfaces.future.IResultSet;
import com.simba.athena.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceID;
import com.simba.athena.dsi.dataengine.utilities.RenameColumn;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.future.SDatabaseMetaData;
import com.simba.athena.jdbc.common.future.SForwardResultSet;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.support.exceptions.ExceptionType;
import com.simba.athena.utilities.JDBCVersion;
import com.simba.athena.utilities.MetaDataFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class SMetaDataProxy
extends SForwardResultSet {
    private List<? extends IColumn> m_columns;
    private final MetadataSourceID m_metadataType;

    protected SMetaDataProxy(SDatabaseMetaData sDatabaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger, JDBCVersion jDBCVersion) throws SQLException {
        super(sDatabaseMetaData, iResultSet, iLogger);
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{sDatabaseMetaData, iResultSet, metadataSourceID, iLogger, jDBCVersion});
        this.m_metadataType = metadataSourceID;
        this.m_jdbcVersion = jDBCVersion;
        try {
            this.m_columns = iResultSet != null ? this.WrapColumnsIfNeeded(iResultSet.getSelectColumns(), metadataSourceID, jDBCVersion) : this.generateMetadataList();
        }
        catch (ErrorException errorException) {
            throw ExceptionConverter.getInstance().toSQLException(errorException, this.m_warningListener, this.m_logger);
        }
        this.initializeColumnNameMap();
    }

    private List<IColumn> WrapColumnsIfNeeded(List<? extends IColumn> list, MetadataSourceID metadataSourceID, JDBCVersion jDBCVersion) throws SQLException {
        List<ColumnMetadata> list2 = this.generateMetadataList();
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String string;
            IColumn iColumn = list.get(i);
            if (i < list2.size() && !(string = list2.get(i).getName()).equalsIgnoreCase(iColumn.getName())) {
                iColumn = new RenameColumn(iColumn, string);
            }
            arrayList.add(iColumn);
        }
        return arrayList;
    }

    private List<ColumnMetadata> generateMetadataList() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        switch (this.m_metadataType) {
            case ATTRIBUTES: {
                return MetaDataFactory.createAttributeMetaData();
            }
            case CATALOG_ONLY: {
                return MetaDataFactory.createCatalogOnlyMetaData();
            }
            case COLUMN_PRIVILEGES: {
                return MetaDataFactory.createColumnPrivilegesMetaData();
            }
            case COLUMNS: {
                return MetaDataFactory.createColumnsMetaData(this.m_jdbcVersion);
            }
            case FOREIGN_KEYS: {
                return MetaDataFactory.createForeignKeysMetaData();
            }
            case FUNCTION_COLUMNS_JDBC4: {
                return MetaDataFactory.createFunctionColumnsMetaData();
            }
            case FUNCTIONS_JDBC4: {
                return MetaDataFactory.createFunctionsMetaData();
            }
            case STATISTICS: {
                return MetaDataFactory.createIndexInfoMetaData();
            }
            case PRIMARY_KEYS: {
                return MetaDataFactory.createPrimaryKeysMetaData();
            }
            case PROCEDURE_COLUMNS: {
                return MetaDataFactory.createProcedureColumnsMetaData(this.m_jdbcVersion);
            }
            case PROCEDURES: {
                return MetaDataFactory.createProceduresMetaData(this.m_jdbcVersion);
            }
            case PSEUDO_COLUMNS_JDBC41: {
                return MetaDataFactory.createPseudoColumnsMetaData();
            }
            case SCHEMA_ONLY: 
            case CATALOG_SCHEMA_ONLY: {
                return MetaDataFactory.createSchemasOnlyMetaData();
            }
            case SPECIAL_COLUMNS: {
                return MetaDataFactory.createSpecialColumnsMetaData();
            }
            case SUPERTABLES: {
                return MetaDataFactory.createSuperTablesMetaData();
            }
            case SUPERTYPES: {
                return MetaDataFactory.createSuperTypesMetaData();
            }
            case TABLE_PRIVILEGES: {
                return MetaDataFactory.createTablePrivilegesMetaData();
            }
            case TABLETYPE_ONLY: {
                return MetaDataFactory.createTableTypesMetaData();
            }
            case TABLES: {
                return MetaDataFactory.createTablesMetaData();
            }
            case TYPE_INFO: {
                return MetaDataFactory.createTypeInfoMetaData();
            }
            case UDT: {
                return MetaDataFactory.createUDTMetaData();
            }
        }
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_METADATA_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf((Object)this.m_metadataType));
    }

    @Override
    protected void initializeResultSetColumns() throws ErrorException, SQLException {
        this.m_resultSetColumns = this.m_columns;
    }
}

