/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin.httpserver;

import com.simba.athena.iamsupport.plugin.httpserver.InternalServerException;
import com.simba.athena.iamsupport.plugin.httpserver.RequestHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ServerSocketFactory;
import org.apache.http.HttpConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpServerConnection;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.DefaultBHttpServerConnectionFactory;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;

public class Server {
    private final DefaultBHttpServerConnectionFactory m_connectionFactory;
    private final HttpService m_httpService;
    private final InetAddress m_ipAddress;
    private final int m_port;
    private int m_localPort;
    private final RequestHandler m_handler;
    private final ServerSocketFactory m_socketFactory;
    private final SocketConfig m_defaultSocketConfig;
    private ListenerThread m_listener;

    public Server(int n, RequestHandler requestHandler, int n2) {
        this.m_port = n;
        this.m_handler = requestHandler;
        this.m_ipAddress = InetAddress.getLoopbackAddress();
        this.m_socketFactory = ServerSocketFactory.getDefault();
        this.m_defaultSocketConfig = SocketConfig.custom().setBacklogSize(1).setSoKeepAlive(false).setSoTimeout(this.toMilliSeconds(n2)).build();
        this.m_httpService = new HttpService(HttpProcessorBuilder.create().add(new ResponseDate()).add(new ResponseContent()).add(new ResponseConnControl()).build(), this.prepareRequestMapper(requestHandler));
        this.m_connectionFactory = DefaultBHttpServerConnectionFactory.INSTANCE;
    }

    public int toMilliSeconds(int n) {
        long l = n * 1000;
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public int getLocalPort() {
        return this.m_localPort;
    }

    public void listen() throws IOException {
        ServerSocket serverSocket = null;
        try {
            serverSocket = this.m_socketFactory.createServerSocket(this.m_port, this.m_defaultSocketConfig.getBacklogSize(), this.m_ipAddress);
            serverSocket.setSoTimeout(this.m_defaultSocketConfig.getSoTimeout());
            this.m_localPort = serverSocket.getLocalPort();
            this.m_listener = new ListenerThread(serverSocket);
            this.m_listener.start();
        }
        catch (Throwable throwable) {
            if (serverSocket != null) {
                serverSocket.close();
            }
            throw throwable;
        }
    }

    public void waitForResult() {
        try {
            this.m_listener.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        this.m_listener.interrupt();
    }

    private UriHttpRequestHandlerMapper prepareRequestMapper(HttpRequestHandler httpRequestHandler) {
        UriHttpRequestHandlerMapper uriHttpRequestHandlerMapper = new UriHttpRequestHandlerMapper();
        uriHttpRequestHandlerMapper.register("*", httpRequestHandler);
        return uriHttpRequestHandlerMapper;
    }

    public class ListenerThread
    extends Thread {
        private final ServerSocket serverSocket;

        ListenerThread(ServerSocket serverSocket) {
            super("http-listener");
            this.serverSocket = serverSocket;
        }

        @Override
        public void run() {
            HttpConnection httpConnection = null;
            try {
                Socket socket = this.serverSocket.accept();
                socket.setKeepAlive(Server.this.m_defaultSocketConfig.isSoKeepAlive());
                socket.setTcpNoDelay(Server.this.m_defaultSocketConfig.isTcpNoDelay());
                if (Server.this.m_defaultSocketConfig.getRcvBufSize() > 0) {
                    socket.setReceiveBufferSize(Server.this.m_defaultSocketConfig.getRcvBufSize());
                }
                if (Server.this.m_defaultSocketConfig.getSndBufSize() > 0) {
                    socket.setSendBufferSize(Server.this.m_defaultSocketConfig.getSndBufSize());
                }
                if (Server.this.m_defaultSocketConfig.getSoLinger() >= 0) {
                    socket.setSoLinger(true, Server.this.m_defaultSocketConfig.getSoLinger());
                }
                httpConnection = Server.this.m_connectionFactory.createConnection(socket);
                BasicHttpContext basicHttpContext = new BasicHttpContext();
                HttpCoreContext httpCoreContext = HttpCoreContext.adapt(basicHttpContext);
                Server.this.m_httpService.handleRequest((HttpServerConnection)httpConnection, httpCoreContext);
                basicHttpContext.clear();
                httpConnection.close();
                httpConnection = null;
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException | HttpException exception) {
                throw InternalServerException.wrap(exception);
            }
            finally {
                try {
                    if (httpConnection != null) {
                        httpConnection.shutdown();
                    }
                    if (!this.serverSocket.isClosed()) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

