/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.future.NonTrivialJDBCConversions;
import com.simba.athena.dsi.core.utilities.impl.future.ConversionConfig;
import com.simba.athena.dsi.core.utilities.impl.future.ConvertingJDBCDataSink;
import com.simba.athena.dsi.dataengine.utilities.TypeMetadata;
import com.simba.athena.dsi.exceptions.ConversionFailed;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.dsi.exceptions.future.UnsupportedException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;

public abstract class LocalTimeJDBCDataSink
extends ConvertingJDBCDataSink {
    private final int m_fractionalSecondsPrecision;

    public LocalTimeJDBCDataSink(IWarningListener iWarningListener, TypeMetadata typeMetadata, ConversionConfig conversionConfig) {
        super(iWarningListener, conversionConfig);
        assert (typeMetadata.getPrecision() >= 0);
        this.m_fractionalSecondsPrecision = typeMetadata.getPrecision();
    }

    protected final int getFractionalSecondsPrecision() {
        return this.m_fractionalSecondsPrecision;
    }

    protected abstract void doSet(LocalTime var1) throws ErrorException;

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null) {
            this.doSet(null);
        } else if (object instanceof LocalTime) {
            this.doSet((LocalTime)object);
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setNull(int n) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        switch (n) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 0: 
            case 1: 
            case 12: 
            case 92: 
            case 93: 
            case 2000: {
                this.doSet(null);
                break;
            }
            default: {
                throw new IncorrectTypeException();
            }
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            LocalTime localTime = NonTrivialJDBCConversions.stringToLocalTime(string, this.getFractionalSecondsPrecision(), this.getAndClearListener());
            if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
                this.onFractionalTruncation(string, this.getFractionalSecondsPrecision(), "setString");
            }
            this.doSet(localTime);
        }
    }

    private void truncateFracSecsIfNeededAndSet(Object object, LocalTime localTime, String string) throws ErrorException, ConversionFailed {
        int n = NonTrivialJDBCConversions.roundNanosecondsToPrecision(localTime.getNano(), this.getFractionalSecondsPrecision());
        if (n != localTime.getNano()) {
            this.onFractionalTruncation(object, this.getFractionalSecondsPrecision(), string);
            localTime = localTime.withNano(n);
        }
        this.doSet(localTime);
    }

    @Override
    public void setTime(Time time, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (time == null) {
            this.doSet(null);
        } else {
            LocalTime localTime = NonTrivialJDBCConversions.sqlTimeToLocalTime(time, this.getFractionalSecondsPrecision(), this.getAndClearListener());
            if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
                this.onFractionalTruncation(time, this.getFractionalSecondsPrecision(), "setTime");
            }
            if (calendar != null) {
                localTime = localTime.atOffset(calendar.getTimeZone().toZoneId().getRules().getOffset(Instant.EPOCH)).withOffsetSameInstant(ZoneOffset.systemDefault().getRules().getOffset(Instant.EPOCH)).toLocalTime();
            }
            this.doSet(localTime);
        }
    }

    @Override
    public void setTimestamp(Timestamp timestamp, Calendar calendar) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException {
        if (timestamp == null) {
            this.setNull(93);
        } else {
            LocalTime localTime = calendar != null ? NonTrivialJDBCConversions.timestampToLocalDateTime(timestamp).atZone(calendar.getTimeZone().toZoneId()).withZoneSameInstant(ZoneId.systemDefault()).toLocalTime() : NonTrivialJDBCConversions.timestampToLocalDateTime(timestamp).toLocalTime();
            this.truncateFracSecsIfNeededAndSet(timestamp, localTime, "setTimestamp");
        }
    }

    @Override
    protected void setLocalTime(LocalTime localTime) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException, UnsupportedException {
        LocalTime localTime2 = NonTrivialJDBCConversions.truncateLocalTimeToPrecision(localTime, this.getFractionalSecondsPrecision(), this.getAndClearListener());
        if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
            this.onFractionalTruncation(localTime, this.getFractionalSecondsPrecision(), "setObject");
        }
        this.doSet(localTime2);
    }

    @Override
    protected void setLocalDateTime(LocalDateTime localDateTime) throws IncorrectTypeException, ConversionFailed, SQLException, ErrorException, UnsupportedException {
        LocalTime localTime = NonTrivialJDBCConversions.truncateLocalTimeToPrecision(localDateTime.toLocalTime(), this.getFractionalSecondsPrecision(), this.getAndClearListener());
        if (this.getListener().getStatus() == NonTrivialJDBCConversions.ConversionStatus.FRACTIONAL_TRUNCATION) {
            this.onFractionalTruncation(localDateTime, this.getFractionalSecondsPrecision(), "setObject");
        }
        this.doSet(localTime);
    }
}

