/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.dsi.dataengine.interfaces.IArray;
import com.simba.athena.dsi.dataengine.utilities.ExecutionContext;
import com.simba.athena.dsi.dataengine.utilities.ExecutionContexts;
import com.simba.athena.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.athena.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.athena.dsi.dataengine.utilities.TimeTz;
import com.simba.athena.dsi.dataengine.utilities.TimestampTz;
import com.simba.athena.dsi.exceptions.DefaultParamException;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.dsi.exceptions.ParamAlreadyPushedException;
import com.simba.athena.jdbc.dataengine.ArrayParamParser;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.support.exceptions.GeneralException;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.codec.binary.Hex;

public class AJDataEngineUtils {
    public static final String AJ_CAST_STR = "cast(";
    public static final int AJ_CHAR_MAX_SIZE = 255;
    public static final int AJ_TINYINT_MAX_VALUE = 127;
    public static final int AJ_TINYINT_MIN_VALUE = -128;
    public static final int AJ_SMALLINT_MAX_VALUE = Short.MAX_VALUE;
    public static final int AJ_SMALLINT_MIN_VALUE = Short.MIN_VALUE;
    public static final int AJ_INTEGER_MAX_VALUE = Integer.MAX_VALUE;
    public static final int AJ_INTEGER_MIN_VALUE = Integer.MIN_VALUE;
    private static AJSettings m_driversettings;
    private static ILogger m_log;

    protected static String constructParameterList(ExecutionContexts executionContexts, AJSettings aJSettings, ILogger iLogger) throws ErrorException {
        int n;
        Object object;
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        m_driversettings = aJSettings;
        m_log = iLogger;
        ArrayParamParser arrayParamParser = new ArrayParamParser(){

            @Override
            public String getLiteral(Object object, short s) throws ErrorException {
                return AJDataEngineUtils.addLiteralToParams(object, s, m_driversettings, m_log).toString();
            }
        };
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        Iterator<ExecutionContext> iterator = executionContexts.contextIterator();
        while (iterator.hasNext()) {
            ExecutionContext executionContext = iterator.next();
            for (int i = 0; i < executionContext.getInputs().size(); ++i) {
                object = executionContext.getInputs().get(i);
                ParameterMetadata parameterMetadata = ((ParameterInputValue)object).getMetadata();
                n = parameterMetadata.getParameterNumber();
                hashMap.put(n, object);
            }
        }
        for (int i = 1; i <= hashMap.size(); ++i) {
            if (0 != stringBuilder.length()) {
                stringBuilder.append(", ");
            }
            ParameterInputValue parameterInputValue = (ParameterInputValue)hashMap.get(i);
            try {
                if (parameterInputValue.getData().isNull()) {
                    stringBuilder.append("null");
                    continue;
                }
                object = parameterInputValue.getData().toString();
                int n2 = ((String)object).indexOf("|");
                n = Integer.parseInt(((String)object).substring(0, n2));
                object = ((String)object).substring(n2 + 1);
                switch (n) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        stringBuilder.append(AJDataEngineUtils.buildParam((String)object, AJDataEngineUtils.determineIntegralType((String)object), false));
                        break;
                    }
                    case -3: {
                        Object object2 = parameterInputValue.getData().getVarBinary();
                        stringBuilder.append((CharSequence)AJDataEngineUtils.addLiteralToParams(object2, n, aJSettings, iLogger));
                        break;
                    }
                    case 1: {
                        int n3 = ((String)object).length();
                        object = ((String)object).replaceAll("'", "''");
                        if (255 >= n3) {
                            stringBuilder.append(AJDataEngineUtils.buildParam((String)object, "CHAR(" + n3 + ")", true));
                            break;
                        }
                        stringBuilder.append("'" + (String)object + "'");
                        break;
                    }
                    case -1: 
                    case 12: {
                        int n4 = ((String)object).length();
                        object = ((String)object).replaceAll("'", "''");
                        stringBuilder.append(AJDataEngineUtils.buildParam((String)object, "VARCHAR(" + n4 + ")", true));
                        break;
                    }
                    case 2003: {
                        Object object2 = parameterInputValue.getData().getArray();
                        object = arrayParamParser.arrayParamtoString((IArray)object2, "array").toString();
                        stringBuilder.append((String)object);
                        break;
                    }
                    default: {
                        stringBuilder.append((CharSequence)AJDataEngineUtils.addLiteralToParams(object, n, aJSettings, iLogger));
                    }
                }
                continue;
            }
            catch (ParamAlreadyPushedException paramAlreadyPushedException) {
                throw new GeneralException(paramAlreadyPushedException.getLocalizedMessage(), 0, (Throwable)paramAlreadyPushedException);
            }
            catch (DefaultParamException defaultParamException) {
                throw new GeneralException(defaultParamException.getLocalizedMessage(), 0, (Throwable)defaultParamException);
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new GeneralException(incorrectTypeException.getLocalizedMessage(), 0, (Throwable)incorrectTypeException);
            }
        }
        return stringBuilder.toString();
    }

    public static int getSQLType(Object object, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        Class<?> clazz = object.getClass();
        if (clazz == Integer.class) {
            return 4;
        }
        if (clazz == BigDecimal.class) {
            return 3;
        }
        if (clazz == Boolean.class) {
            return 16;
        }
        if (clazz == Short.class) {
            return -6;
        }
        if (clazz == BigInteger.class || clazz == Long.class) {
            return -5;
        }
        if (clazz == Float.class) {
            return 7;
        }
        if (clazz == Double.class) {
            return 8;
        }
        if (clazz == Date.class || clazz == java.util.Date.class) {
            return 91;
        }
        if (clazz == Time.class || clazz == TimeTz.class) {
            return 92;
        }
        if (clazz == TimestampTz.class || clazz == Timestamp.class) {
            return 93;
        }
        if (clazz == byte[].class || clazz == ByteArrayInputStream.class) {
            return -3;
        }
        if (clazz == String.class) {
            return 12;
        }
        if (clazz == Character.class) {
            return 1;
        }
        if (clazz.getName().startsWith("[")) {
            return 2003;
        }
        return 2000;
    }

    private static StringBuilder addLiteralToParams(Object object, int n, AJSettings aJSettings, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, n);
        StringBuilder stringBuilder = new StringBuilder();
        String string = object.toString();
        switch (n) {
            case 16: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "BOOLEAN", true));
                break;
            }
            case 5: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "SMALLINT", false));
                break;
            }
            case -5: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "BIGINT", false));
                break;
            }
            case 4: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "INTEGER", false));
                break;
            }
            case -6: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "TINYINT", false));
                break;
            }
            case 12: {
                int n2 = string.length();
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "VARCHAR(" + n2 + ")", true));
                break;
            }
            case 1: {
                int n3 = string.length();
                string = string.replaceAll("'", "''");
                if (255 < n3) break;
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "CHAR(" + n3 + ")", true));
                break;
            }
            case -3: {
                Object object2;
                Class<?> clazz = object.getClass();
                byte[] byArray = null;
                if (clazz == ByteArrayInputStream.class) {
                    object2 = (ByteArrayInputStream)object;
                    byArray = new byte[((ByteArrayInputStream)object2).available()];
                } else {
                    byArray = (byte[])object;
                }
                object2 = Hex.encodeHexString(byArray);
                object2 = "X'" + (String)object2 + "'";
                stringBuilder.append(AJDataEngineUtils.buildParam((String)object2, "VARBINARY", false));
                break;
            }
            case 2: 
            case 3: {
                int n4 = string.indexOf(".");
                int n5 = string.length();
                int n6 = 0;
                if (-1 != n4) {
                    n6 = string.substring(n4 + 1).length();
                    --n5;
                }
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "DECIMAL(" + n5 + "," + n6 + ")", false));
                break;
            }
            case 8: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "DOUBLE", false));
                break;
            }
            case 6: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "FLOAT", true));
            }
            case 7: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "REAL", true));
                break;
            }
            case 91: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "DATE", true));
                break;
            }
            case 93: {
                stringBuilder.append(AJDataEngineUtils.buildParam(string, "TIMESTAMP", true));
                break;
            }
            default: {
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.PARAMETER_TYPE_NOT_SUPPORTED_ERR.name(), object.getClass().getName());
            }
        }
        return stringBuilder;
    }

    public static Object convertStringToSQLType(String string, String string2, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        string2 = string2.toLowerCase();
        if (string2.equals("boolean")) {
            return Boolean.parseBoolean(string);
        }
        if (string2.startsWith("bigint")) {
            return Long.parseLong(string);
        }
        if (string2.startsWith("double")) {
            return Double.parseDouble(string);
        }
        if (string2.startsWith("decimal")) {
            return new BigDecimal(string);
        }
        if (string2.startsWith("real")) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (string2.startsWith("integer") || string2.startsWith("smallint")) {
            return Integer.parseInt(string);
        }
        if (string2.startsWith("tinyint")) {
            return Short.valueOf(string);
        }
        if (string2.endsWith("date")) {
            return Date.valueOf(string);
        }
        if (string2.endsWith("timestamp")) {
            return Timestamp.valueOf(string);
        }
        if (string2.endsWith("time")) {
            return Time.valueOf(string);
        }
        if (string2.startsWith("varchar") || string2.startsWith("char") || string2.startsWith("time with time zone") || string2.startsWith("timestamp with time zone") || string2.startsWith("interval year to month") || string2.startsWith("interval day to second") || string2.startsWith("json") || string2.startsWith("type_timestamp") || string2.startsWith("time")) {
            return string;
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.PARAMETER_TYPE_NOT_SUPPORTED_ERR.name(), string2);
    }

    protected static String buildParam(String string, String string2, boolean bl) {
        String string3 = "";
        string3 = bl ? "cast('" + string + "' as " + string2 + ")" : AJ_CAST_STR + string + " as " + string2 + ")";
        return string3;
    }

    protected static String determineIntegralType(String string) {
        long l = Long.parseLong(string);
        if (127L >= l && -128L <= l) {
            return "TINYINT";
        }
        if (32767L >= l && -32768L <= l) {
            return "SMALLINT";
        }
        if (Integer.MAX_VALUE >= l && Integer.MIN_VALUE <= l) {
            return "INTEGER";
        }
        return "BIGINT";
    }
}

